/*
 * Decompiled with CFR 0.152.
 */
package snownee.passablefoliage;

import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import snownee.passablefoliage.EnchantmentModule;
import snownee.passablefoliage.PassableFoliageBlock;
import snownee.passablefoliage.PassableFoliageCommonConfig;

public final class PassableFoliage {
    public static final String ID = "passablefoliage";
    public static boolean enchantmentEnabled;
    public static ThreadLocal<Boolean> suppressPassableCheck;

    public static void onEntityCollidedWithLeaves(Level world, BlockPos pos, BlockState blockState, Entity entity) {
        Player player;
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingEntity = (LivingEntity)entity;
        if (entity instanceof Player && (player = (Player)entity).isCreative() && player.getAbilities().flying) {
            return;
        }
        if (!entity.isPassenger()) {
            PassableFoliage.setSuppressPassableCheck(true);
            if (!entity.isColliding(pos, blockState)) {
                PassableFoliage.setSuppressPassableCheck(false);
                return;
            }
            PassableFoliage.setSuppressPassableCheck(false);
        }
        if ((!PassableFoliageCommonConfig.soundsPlayerOnly || entity instanceof Player) && blockState.is(BlockTags.LEAVES)) {
            double motion;
            if (livingEntity.fallDistance > 3.0f) {
                SoundType soundType = blockState.getSoundType();
                entity.playSound(soundType.getBreakSound(), soundType.getVolume() * 0.6f * PassableFoliageCommonConfig.soundVolume, soundType.getPitch() * 0.65f);
            } else if (world.getGameTime() % 6L == 0L && (motion = entity.getDeltaMovement().lengthSqr()) > 5.0E-7) {
                SoundType soundType = blockState.getSoundType();
                entity.playSound(soundType.getHitSound(), soundType.getVolume() * 0.5f * PassableFoliageCommonConfig.soundVolume, soundType.getPitch() * 0.45f);
            }
        }
        float h = 1.0f;
        float v = 1.0f;
        if ((PassableFoliageCommonConfig.alwaysLeafWalking || !PassableFoliage.hasLeafWalker(livingEntity)) && livingEntity.getDeltaMovement().y() <= 0.0) {
            v = PassableFoliageCommonConfig.speedReductionVertical;
            h = PassableFoliageCommonConfig.speedReductionHorizontal;
        }
        if (h < 1.0f || v < 1.0f) {
            Vec3 newMotion = entity.getDeltaMovement().multiply((double)h, (double)v, (double)h);
            entity.setDeltaMovement(newMotion);
        }
        if (livingEntity.fallDistance > (float)PassableFoliageCommonConfig.fallDamageThreshold) {
            livingEntity.fallDistance -= (float)PassableFoliageCommonConfig.fallDamageThreshold;
            livingEntity.causeFallDamage((float)PassableFoliageCommonConfig.fallDamageThreshold, 1.0f - PassableFoliageCommonConfig.fallDamageReduction, world.damageSources().fall());
        }
        if (livingEntity.fallDistance > 1.0f) {
            livingEntity.fallDistance = 1.0f;
        }
        if (entity.isVehicle()) {
            for (Entity ent : entity.getPassengers()) {
                PassableFoliage.onEntityCollidedWithLeaves(world, pos, blockState, ent);
            }
        }
    }

    public static boolean isPassable(BlockState state) {
        return ((PassableFoliageBlock)state.getBlock()).pfoliage$isPassable() && suppressPassableCheck.get() == false;
    }

    public static boolean hasLeafWalker(LivingEntity entity) {
        return PassableFoliageCommonConfig.alwaysLeafWalking || enchantmentEnabled && EnchantmentHelper.has((ItemStack)entity.getItemBySlot(EquipmentSlot.FEET), (DataComponentType)((DataComponentType)EnchantmentModule.LEAF_WALKER.get()));
    }

    public static void setSuppressPassableCheck(boolean suppressPassableCheck) {
        PassableFoliage.suppressPassableCheck.set(suppressPassableCheck);
    }

    static {
        suppressPassableCheck = ThreadLocal.withInitial(() -> false);
    }
}

