/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.network;

import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.command.MaterialsCommand;
import net.silentchaos512.gear.command.TraitsCommand;
import net.silentchaos512.gear.network.payload.client.AckPayload;
import net.silentchaos512.gear.network.payload.server.CommandOutputPayload;
import net.silentchaos512.gear.network.payload.server.OpenGuideBookPayload;
import net.silentchaos512.gear.network.payload.server.SyncMaterialsPayload;
import net.silentchaos512.gear.network.payload.server.SyncPartsPayload;
import net.silentchaos512.gear.network.payload.server.SyncTraitsPayload;
import net.silentchaos512.gear.setup.SgRegistries;
import net.silentchaos512.gear.util.TextUtil;

public class SgClientPayloadHandler {
    private static final SgClientPayloadHandler INSTANCE = new SgClientPayloadHandler();

    public static SgClientPayloadHandler getInstance() {
        return INSTANCE;
    }

    private static CompletableFuture<Void> handleData(IPayloadContext ctx, Runnable handler) {
        return ctx.enqueueWork(handler).exceptionally(e -> {
            ctx.disconnect((Component)Component.translatable((String)"network.silentgear.failure", (Object[])new Object[]{e.getMessage()}));
            return null;
        });
    }

    public void handleSyncTraits(SyncTraitsPayload data, IPayloadContext ctx) {
        SgClientPayloadHandler.handleData(ctx, () -> SgRegistries.TRAIT.handleSyncPacket(data, ctx)).thenAccept(v -> ctx.reply((CustomPacketPayload)new AckPayload()));
    }

    public void handleSyncMaterials(SyncMaterialsPayload data, IPayloadContext ctx) {
        SgClientPayloadHandler.handleData(ctx, () -> SgRegistries.MATERIAL.handleSyncPacket(data, ctx)).thenAccept(v -> ctx.reply((CustomPacketPayload)new AckPayload()));
    }

    public void handleSyncParts(SyncPartsPayload data, IPayloadContext ctx) {
        SgClientPayloadHandler.handleData(ctx, () -> SgRegistries.PART.handleSyncPacket(data, ctx)).thenAccept(v -> ctx.reply((CustomPacketPayload)new AckPayload()));
    }

    public void handleCommandOutput(CommandOutputPayload data, IPayloadContext ctx) {
        switch (data.commandType()) {
            case MATERIALS: {
                MaterialsCommand.runDumpClient(data.includeChildren());
                break;
            }
            case TRAITS: {
                TraitsCommand.runDumpMdClient();
                break;
            }
            default: {
                SilentGear.LOGGER.error("Unknown ClientOutputCommandPacket.Type: {}", (Object)data.commandType());
            }
        }
    }

    public void handleOpenGuideBook(OpenGuideBookPayload data, IPayloadContext ctx) {
        SgClientPayloadHandler.handleData(ctx, () -> {
            Player player = ctx.player();
            String wikiUrl = "https://github.com/SilentChaos512/Silent-Gear/wiki";
            player.sendSystemMessage((Component)TextUtil.translate("item", "guide_book.unimplemented1"));
            player.sendSystemMessage((Component)TextUtil.translate("item", "guide_book.check_wiki").append((Component)Component.literal((String)wikiUrl).withStyle(ChatFormatting.UNDERLINE).withStyle(style -> style.withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, wikiUrl)))));
        });
    }
}

