/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.recipes;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.Material;
import net.silentchaos512.gear.api.util.DataResource;
import net.silentchaos512.gear.crafting.recipe.alloy.AlloyRecipe;
import net.silentchaos512.gear.crafting.recipe.alloy.FabricAlloyRecipe;
import net.silentchaos512.gear.crafting.recipe.alloy.GemAlloyRecipe;
import net.silentchaos512.gear.crafting.recipe.alloy.MetalAlloyRecipe;

public class CompoundingRecipeBuilder<R extends AlloyRecipe>
implements RecipeBuilder {
    private final AlloyRecipe.Factory<R> factory;
    private final String recipeFolder;
    private final List<Ingredient> ingredients = new ArrayList<Ingredient>();
    private final Item resultItem;
    private final int resultCount;
    @Nullable
    private DataResource<Material> resultMaterial;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public CompoundingRecipeBuilder(AlloyRecipe.Factory<R> factory, String recipeFolder, ItemLike resultItem, int count) {
        this.factory = factory;
        this.recipeFolder = recipeFolder;
        this.resultItem = resultItem.asItem();
        this.resultCount = count;
    }

    public static CompoundingRecipeBuilder<MetalAlloyRecipe> metalBuilder(ItemLike result, int count) {
        return new CompoundingRecipeBuilder<MetalAlloyRecipe>(MetalAlloyRecipe::new, "metal", result, count);
    }

    public static CompoundingRecipeBuilder<GemAlloyRecipe> gemBuilder(ItemLike result, int count) {
        return new CompoundingRecipeBuilder<GemAlloyRecipe>(GemAlloyRecipe::new, "gem", result, count);
    }

    public static CompoundingRecipeBuilder<FabricAlloyRecipe> fabricBuilder(ItemLike result, int count) {
        return new CompoundingRecipeBuilder<FabricAlloyRecipe>(FabricAlloyRecipe::new, "fabric", result, count);
    }

    public CompoundingRecipeBuilder<R> withCustomMaterial(DataResource<Material> material) {
        this.resultMaterial = material;
        return this;
    }

    public CompoundingRecipeBuilder<R> addIngredient(ItemLike item) {
        return this.addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{item}));
    }

    public CompoundingRecipeBuilder<R> addIngredient(ItemLike item, int count) {
        return this.addIngredient(Ingredient.of((ItemLike[])new ItemLike[]{item}), count);
    }

    public CompoundingRecipeBuilder<R> addIngredient(TagKey<Item> tag) {
        return this.addIngredient(Ingredient.of(tag));
    }

    public CompoundingRecipeBuilder<R> addIngredient(TagKey<Item> tag, int count) {
        return this.addIngredient(Ingredient.of(tag), count);
    }

    public CompoundingRecipeBuilder<R> addIngredient(Ingredient ingredient) {
        return this.addIngredient(ingredient, 1);
    }

    public CompoundingRecipeBuilder<R> addIngredient(Ingredient ingredient, int count) {
        for (int i = 0; i < count; ++i) {
            this.ingredients.add(ingredient);
        }
        return this;
    }

    public RecipeBuilder unlockedBy(String pName, Criterion<?> pCriterion) {
        this.criteria.put(pName, pCriterion);
        return this;
    }

    public RecipeBuilder group(@Nullable String pGroupName) {
        return this;
    }

    public Item getResult() {
        return this.resultItem;
    }

    public void save(RecipeOutput pRecipeOutput) {
        String name = "alloying/" + this.recipeFolder + "/" + BuiltInRegistries.ITEM.getKey((Object)this.resultItem).getPath();
        if (this.resultMaterial != null) {
            name = name + "." + this.resultMaterial.getId().getPath();
        }
        this.save(pRecipeOutput, SilentGear.getId(name));
    }

    public void save(RecipeOutput pRecipeOutput, ResourceLocation pId) {
        Advancement.Builder advancement$builder = null;
        if (!this.criteria.isEmpty()) {
            advancement$builder = pRecipeOutput.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)pId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)pId)).requirements(AdvancementRequirements.Strategy.OR);
            this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)advancement$builder).addCriterion(arg_0, arg_1));
        }
        R recipe = this.factory.create(new AlloyRecipe.Result(this.resultItem, this.resultCount, this.resultMaterial), this.ingredients);
        AdvancementHolder advancementHolder = advancement$builder != null ? advancement$builder.build(pId.withPrefix("recipes/alloying/" + this.recipeFolder + "/")) : null;
        pRecipeOutput.accept(pId, recipe, advancementHolder);
    }
}

