/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.placeable_book;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.Set;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacement;
import net.mehvahdjukaar.moonlight.api.item.additional_placements.AdditionalItemPlacementsAPI;
import net.mehvahdjukaar.moonlight.api.misc.SidedInstance;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.placeable_book.BookType;
import net.mehvahdjukaar.supplementaries.common.events.overrides.SuppAdditionalPlacement;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundFinalizeBookDataPacket;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class PlaceableBookManager {
    public static final ResourceKey<Registry<BookType>> REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)Supplementaries.res("placeable_books"));
    private static final SidedInstance<Multimap<Item, BookType>> ITEMS_TO_BOOKS = SidedInstance.of(PlaceableBookManager::populateData);
    private static final Set<Item> ITEMS_WITH_PLACEMENTS = new HashSet<Item>();
    private static SuppAdditionalPlacement horizontalPlacement;
    private static SuppAdditionalPlacement verticalPlacement;

    public static void init() {
        RegHelper.registerDataPackRegistry(REGISTRY_KEY, BookType.CODEC, BookType.CODEC);
    }

    public static void setup() {
        horizontalPlacement = new SuppAdditionalPlacement(ModRegistry.BOOK_PILE_H.get());
        verticalPlacement = new SuppAdditionalPlacement(ModRegistry.BOOK_PILE.get());
    }

    public static HolderLookup.RegistryLookup<BookType> getRegistry(HolderLookup.Provider ra) {
        return ra.lookupOrThrow(REGISTRY_KEY);
    }

    public static void registerBookPlacements(RegistryAccess registryAccess) {
        HolderLookup.RegistryLookup<BookType> reg = PlaceableBookManager.getRegistry((HolderLookup.Provider)registryAccess);
        for (Item entry : ITEMS_WITH_PLACEMENTS) {
            AdditionalItemPlacementsAPI.unregisterPlacement((Item)entry);
        }
        if (CommonConfigs.Tweaks.PLACEABLE_BOOKS.get().booleanValue()) {
            for (Item entry : reg.listElements().toList()) {
                BookType value = (BookType)entry.value();
                Item item = value.item();
                AdditionalItemPlacementsAPI.registerPlacement((Item)item, (AdditionalItemPlacement)(value.isHorizontal() ? horizontalPlacement : verticalPlacement));
                ITEMS_WITH_PLACEMENTS.add(item);
            }
        }
    }

    public static HashMultimap<Item, BookType> populateData(HolderLookup.Provider ra) {
        HashMultimap itemToBooks = HashMultimap.create();
        HolderLookup.RegistryLookup<BookType> reg = PlaceableBookManager.getRegistry(ra);
        for (Holder.Reference entry : reg.listElements().toList()) {
            BookType value = (BookType)entry.value();
            Item item = value.item();
            itemToBooks.put((Object)item, (Object)value);
        }
        return itemToBooks;
    }

    @Nullable
    public static BookType get(Item item, boolean horizontal, HolderLookup.Provider ra) {
        for (BookType entry : ((Multimap)ITEMS_TO_BOOKS.get(ra)).get((Object)item)) {
            if (entry.isHorizontal() != horizontal && !CommonConfigs.Tweaks.MIXED_BOOKS.get().booleanValue()) continue;
            return entry;
        }
        return null;
    }

    public static void onDataSync(ServerPlayer player, boolean joined) {
        if (joined) {
            NetworkHelper.sendToClientPlayer((ServerPlayer)player, (CustomPacketPayload)new ClientBoundFinalizeBookDataPacket());
        }
    }
}

