/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.faucet;

import com.google.common.base.Preconditions;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.misc.SidedInstance;
import net.mehvahdjukaar.moonlight.api.misc.fake_level.FakeLevelManager;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.FakePlayerManager;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.common.block.faucet.APIFluidTankInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.BeehiveInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.BrewingStandInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.ConcreteInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.ContainerItemInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.DataFluidInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.DataItemInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetItemSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetTarget;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FiniteFluidInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FullBucketCauldronInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.LiquidBlockInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.MudInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.PowderSnowCauldronInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.SappyLogInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.SoftFluidProviderInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.SoftFluidTankInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.SpongeInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.WaterCauldronInteraction;
import net.mehvahdjukaar.supplementaries.common.block.faucet.XPDroppingInteraction;
import net.mehvahdjukaar.supplementaries.common.utils.fake_level.BlockTestLevel;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.cauldron.CauldronInteraction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FaucetBehaviorsManager
extends SimpleJsonResourceReloadListener {
    private static final Codec<Either<DataItemInteraction, DataFluidInteraction>> CODEC = Codec.either(DataItemInteraction.CODEC, DataFluidInteraction.CODEC);
    private static final Set<Consumer<IFaucetEvent>> SERVER_LISTENERS = new HashSet<Consumer<IFaucetEvent>>();
    private static final SidedInstance<FaucetBehaviorsManager> INSTANCES = SidedInstance.of(FaucetBehaviorsManager::new);
    private final List<FaucetSource.BlState> blockInteractions = new ArrayList<FaucetSource.BlState>();
    private final List<FaucetSource.Tile> tileInteraction = new ArrayList<FaucetSource.Tile>();
    private final List<FaucetSource.Fluid> sourceFluidInteractions = new ArrayList<FaucetSource.Fluid>();
    private final List<FaucetItemSource> itemInteractions = new ArrayList<FaucetItemSource>();
    private final List<FaucetTarget.BlState> targetBlockInteractions = new ArrayList<FaucetTarget.BlState>();
    private final List<FaucetTarget.Tile> targetTileInteractions = new ArrayList<FaucetTarget.Tile>();
    private final List<FaucetTarget.Fluid> targetFluidInteractions = new ArrayList<FaucetTarget.Fluid>();
    private final HolderLookup.Provider registryAccess;

    public static FaucetBehaviorsManager getInstance(HolderLookup.Provider ra) {
        return (FaucetBehaviorsManager)((Object)INSTANCES.get(ra));
    }

    public static FaucetBehaviorsManager getInstance(@NotNull Level level) {
        Preconditions.checkNotNull((Object)level);
        return FaucetBehaviorsManager.getInstance((HolderLookup.Provider)level.registryAccess());
    }

    public static synchronized void addRegisterFaucetInteractions(Consumer<IFaucetEvent> listener) {
        SERVER_LISTENERS.add(listener);
    }

    public FaucetBehaviorsManager(HolderLookup.Provider ra) {
        super(new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create(), "faucet_interactions");
        this.registryAccess = ra;
        INSTANCES.set(ra, (Object)this);
    }

    public Iterable<FaucetSource.BlState> getBlockInteractions() {
        return this.blockInteractions;
    }

    public Iterable<FaucetSource.Tile> getTileInteractions() {
        return this.tileInteraction;
    }

    public Iterable<FaucetSource.Fluid> getSourceFluidInteractions() {
        return this.sourceFluidInteractions;
    }

    public Iterable<FaucetItemSource> getItemInteractions() {
        return this.itemInteractions;
    }

    public Iterable<FaucetTarget.BlState> getTargetBlockInteractions() {
        return this.targetBlockInteractions;
    }

    public Iterable<FaucetTarget.Tile> getTargetTileInteractions() {
        return this.targetTileInteractions;
    }

    public Iterable<FaucetTarget.Fluid> getTargetFluidInteractions() {
        return this.targetFluidInteractions;
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.tileInteraction.clear();
        this.sourceFluidInteractions.clear();
        this.itemInteractions.clear();
        this.targetBlockInteractions.clear();
        this.targetTileInteractions.clear();
        this.targetFluidInteractions.clear();
        RegistryOps ops = ForgeHelper.conditionalOps((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)this.registryAccess, (SimplePreparableReloadListener)this);
        Codec codec = ForgeHelper.conditionalCodec(CODEC);
        ArrayList dataInteractions = new ArrayList();
        ArrayList dataFluidInteractions = new ArrayList();
        map.forEach((key, json) -> {
            try {
                Either either = (Either)((Optional)codec.parse((DynamicOps)ops, json).getOrThrow()).get();
                if (either.left().isPresent()) {
                    DataItemInteraction interaction = (DataItemInteraction)either.left().get();
                    dataInteractions.add(interaction);
                } else if (either.right().isPresent()) {
                    DataFluidInteraction interaction = (DataFluidInteraction)either.right().get();
                    dataFluidInteractions.add(interaction);
                }
            }
            catch (Exception e) {
                Supplementaries.LOGGER.error("Failed to parse JSON object for faucet interaction {}", key, (Object)e);
            }
        });
        if (!dataFluidInteractions.isEmpty()) {
            Supplementaries.LOGGER.info("Loaded  {} custom faucet interactions", (Object)(dataFluidInteractions.size() + dataInteractions.size()));
        }
        dataInteractions.forEach(this::registerInteraction);
        dataFluidInteractions.forEach(this::registerInteraction);
        this.registerInteraction(new SoftFluidProviderInteraction());
        this.registerInteraction(new WaterCauldronInteraction());
        this.registerInteraction(new FullBucketCauldronInteraction(Blocks.LAVA_CAULDRON.defaultBlockState(), Items.LAVA_BUCKET.getDefaultInstance()));
        this.registerInteraction(new PowderSnowCauldronInteraction());
        this.registerInteraction(new BeehiveInteraction());
        this.registerInteraction(new SoftFluidTankInteraction());
        this.registerInteraction(new APIFluidTankInteraction());
        this.registerInteraction(new BrewingStandInteraction());
        this.registerInteraction(new FiniteFluidInteraction());
        this.registerInteraction(new LiquidBlockInteraction());
        this.registerInteraction(new SpongeInteraction());
        this.registerInteraction(new XPDroppingInteraction());
        this.registerInteraction(new ConcreteInteraction());
        this.registerInteraction(new MudInteraction());
        this.registerInteraction(new ContainerItemInteraction());
        if (CompatHandler.AUTUMNITY) {
            this.registerInteraction(new SappyLogInteraction());
        }
        SERVER_LISTENERS.forEach(l -> l.accept(this::registerInteraction));
        MinecraftServer currentServer = PlatHelper.getCurrentServer();
        if (currentServer == null) {
            return;
        }
        ServerLevel overworld = currentServer.overworld();
        this.onLevelLoad(overworld);
    }

    public void onLevelLoad(ServerLevel level) {
        BlockTestLevel testLevel = BlockTestLevel.get(level);
        Player player = FakePlayerManager.getDefault((Level)testLevel);
        InteractionHand hand = InteractionHand.MAIN_HAND;
        BlockState emptyCauldron = Blocks.CAULDRON.defaultBlockState();
        for (Map.Entry e : CauldronInteraction.EMPTY.map().entrySet()) {
            Item i = (Item)e.getKey();
            CauldronInteraction interaction = (CauldronInteraction)e.getValue();
            if (Utils.getID((Item)i).getNamespace().equals("minecraft")) continue;
            testLevel.setup();
            ItemStack fullBucket = i.getDefaultInstance();
            ItemStack fullBucketCopy = fullBucket.copy();
            player.setItemInHand(hand, fullBucket);
            interaction.interact(emptyCauldron, (Level)testLevel, BlockPos.ZERO, player, hand, fullBucket);
            BlockState fullCauldron = testLevel.blockState;
            if (fullCauldron == null || fullCauldron.hasProperty((Property)LayeredCauldronBlock.LEVEL) && PlatHelper.getPlatform().isForge()) continue;
            this.registerInteraction(new FullBucketCauldronInteraction(fullCauldron, fullBucketCopy));
        }
        FakeLevelManager.invalidate((Level)testLevel);
    }

    protected void registerInteraction(Object interaction) {
        FaucetSource<BlockState> bs;
        boolean success = false;
        if (interaction instanceof FaucetSource.BlState) {
            bs = (FaucetSource.BlState)interaction;
            this.blockInteractions.add((FaucetSource.BlState)bs);
            success = true;
        }
        if (interaction instanceof FaucetSource.Tile) {
            FaucetSource.Tile ts = (FaucetSource.Tile)interaction;
            this.tileInteraction.add(ts);
            success = true;
        }
        if (interaction instanceof FaucetSource.Fluid) {
            bs = (FaucetSource.Fluid)interaction;
            this.sourceFluidInteractions.add((FaucetSource.Fluid)bs);
            success = true;
        }
        if (interaction instanceof FaucetTarget.BlState) {
            FaucetTarget.BlState tb = (FaucetTarget.BlState)interaction;
            this.targetBlockInteractions.add(tb);
            success = true;
        }
        if (interaction instanceof FaucetTarget.Tile) {
            FaucetTarget.Tile tt = (FaucetTarget.Tile)interaction;
            this.targetTileInteractions.add(tt);
            success = true;
        }
        if (interaction instanceof FaucetTarget.Fluid) {
            FaucetTarget.Fluid tf = (FaucetTarget.Fluid)interaction;
            this.targetFluidInteractions.add(tf);
            success = true;
        }
        if (interaction instanceof FaucetItemSource) {
            FaucetItemSource is = (FaucetItemSource)interaction;
            this.itemInteractions.add(is);
            success = true;
        }
        if (!success) {
            throw new UnsupportedOperationException("Unsupported faucet interaction class: " + interaction.getClass().getSimpleName());
        }
    }

    @Deprecated(forRemoval=true)
    public static void prepareToTransferBottle(SoftFluidTank tempFluidHolder, SoftFluid softFluid, @Nullable CompoundTag tag) {
    }

    public static interface IFaucetEvent {
        public void registerInteraction(Object var1);
    }
}

