/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.inventory.container;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.ICuriosMenu;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.CuriosConfig;
import top.theillusivec4.curios.common.CuriosRegistry;
import top.theillusivec4.curios.common.inventory.CurioSlot;
import top.theillusivec4.curios.common.network.server.SPacketPage;
import top.theillusivec4.curios.common.network.server.SPacketQuickMove;

public class CuriosContainer
extends RecipeBookMenu<RecipeInput, Recipe<RecipeInput>>
implements ICuriosMenu {
    private static final ResourceLocation[] ARMOR_SLOT_TEXTURES = new ResourceLocation[]{InventoryMenu.EMPTY_ARMOR_SLOT_BOOTS, InventoryMenu.EMPTY_ARMOR_SLOT_LEGGINGS, InventoryMenu.EMPTY_ARMOR_SLOT_CHESTPLATE, InventoryMenu.EMPTY_ARMOR_SLOT_HELMET};
    private static final EquipmentSlot[] VALID_EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
    public final ICuriosItemHandler curiosHandler;
    public final Player player;
    private final boolean isLocalWorld;
    private final CraftingContainer craftMatrix = new TransientCraftingContainer((AbstractContainerMenu)this, 2, 2);
    private final ResultContainer craftResult = new ResultContainer();
    public int currentPage;
    public int totalPages;
    public List<Integer> grid = new ArrayList<Integer>();
    private final List<ProxySlot> proxySlots = new ArrayList<ProxySlot>();
    private int moveToPage = -1;
    private int moveFromIndex = -1;
    public boolean hasCosmetics;
    public boolean isViewingCosmetics;
    public int panelWidth;

    public CuriosContainer(int windowId, Inventory playerInventory, FriendlyByteBuf packetBuffer) {
        this(windowId, playerInventory);
    }

    public CuriosContainer(int windowId, Inventory playerInventory) {
        super(CuriosRegistry.CURIO_MENU.get(), windowId);
        this.player = playerInventory.player;
        this.isLocalWorld = this.player.level().isClientSide;
        this.curiosHandler = CuriosApi.getCuriosInventory((LivingEntity)this.player).orElse(null);
        this.resetSlots();
    }

    public void setPage(int page) {
        this.slots.clear();
        this.lastSlots.clear();
        this.remoteSlots.clear();
        this.panelWidth = 0;
        int visibleSlots = 0;
        int maxSlotsPerPage = (Integer)CuriosConfig.SERVER.maxSlotsPerPage.get();
        int startingIndex = page * maxSlotsPerPage;
        int columns = 0;
        if (this.curiosHandler != null) {
            visibleSlots = this.curiosHandler.getVisibleSlots();
            int slotsOnPage = Math.min(maxSlotsPerPage, visibleSlots - startingIndex);
            int calculatedColumns = (int)Math.ceil((double)slotsOnPage / 8.0);
            int minimumColumns = Math.min(slotsOnPage, (Integer)CuriosConfig.SERVER.minimumColumns.get());
            columns = Mth.clamp((int)calculatedColumns, (int)minimumColumns, (int)8);
            this.panelWidth = 14 + 18 * columns;
        }
        this.addSlot((Slot)new ResultSlot(this.player, this.craftMatrix, (Container)this.craftResult, 0, 154, 28));
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.addSlot(new Slot((Container)this.craftMatrix, j + i * 2, 98 + j * 18, 18 + i * 18));
            }
        }
        for (int k = 0; k < 4; ++k) {
            final EquipmentSlot equipmentslottype = VALID_EQUIPMENT_SLOTS[k];
            this.addSlot(new Slot((Container)this.player.getInventory(), 36 + (3 - k), 8, 8 + k * 18){

                public void set(@Nonnull ItemStack stack) {
                    ItemStack itemstack = this.getItem();
                    super.set(stack);
                    CuriosContainer.this.player.onEquipItem(equipmentslottype, itemstack, stack);
                }

                public int getMaxStackSize() {
                    return 1;
                }

                public boolean mayPlace(@Nonnull ItemStack stack) {
                    return stack.canEquip(equipmentslottype, (LivingEntity)CuriosContainer.this.player);
                }

                public boolean mayPickup(@Nonnull Player playerIn) {
                    ItemStack itemstack = this.getItem();
                    return (itemstack.isEmpty() || playerIn.isCreative() || EnchantmentHelper.getItemEnchantmentLevel((Holder)playerIn.level().holderLookup(Registries.ENCHANTMENT).getOrThrow(Enchantments.BINDING_CURSE), (ItemStack)itemstack) == 0) && super.mayPickup(playerIn);
                }

                @OnlyIn(value=Dist.CLIENT)
                public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                    return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)ARMOR_SLOT_TEXTURES[equipmentslottype.getIndex()]);
                }
            });
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.addSlot(new Slot((Container)this.player.getInventory(), j1 + (l + 1) * 9, 8 + j1 * 18, 84 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.addSlot(new Slot((Container)this.player.getInventory(), i1, 8 + i1 * 18, 142));
        }
        this.addSlot(new Slot(this, (Container)this.player.getInventory(), 40, 77, 62){

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                return Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)InventoryMenu.EMPTY_ARMOR_SLOT_SHIELD);
            }
        });
        if (this.curiosHandler != null) {
            Map<String, ICurioStacksHandler> curioMap = this.curiosHandler.getCurios();
            this.totalPages = (int)Math.ceil((double)visibleSlots / (double)maxSlotsPerPage);
            int index = 0;
            int yOffset = 8;
            if (this.totalPages > 1) {
                yOffset += 8;
            }
            int currentColumn = 1;
            int currentRow = 1;
            int slots = 0;
            this.grid.clear();
            this.proxySlots.clear();
            int currentPage = 0;
            int endingIndex = startingIndex + maxSlotsPerPage;
            for (String identifier : curioMap.keySet()) {
                ICurioStacksHandler stacksHandler = curioMap.get(identifier);
                boolean isCosmetic = false;
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                if (stacksHandler.hasCosmetic()) {
                    this.hasCosmetics = true;
                    if (this.isViewingCosmetics) {
                        isCosmetic = true;
                        stackHandler = stacksHandler.getCosmeticStacks();
                    }
                }
                if (!stacksHandler.isVisible()) continue;
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    if (index >= startingIndex && index < endingIndex) {
                        if (isCosmetic) {
                            this.addSlot((Slot)new CurioSlot(this.player, stackHandler, i, identifier, (currentColumn - 1) * 18 + 7 - this.panelWidth, yOffset + (currentRow - 1) * 18, stacksHandler.getRenders(), stacksHandler.canToggleRendering(), true, true));
                        } else {
                            this.addSlot((Slot)new CurioSlot(this.player, stackHandler, i, identifier, (currentColumn - 1) * 18 + 7 - this.panelWidth, yOffset + (currentRow - 1) * 18, stacksHandler.getRenders(), stacksHandler.canToggleRendering(), false, false));
                        }
                        if (this.grid.size() < currentColumn) {
                            this.grid.add(1);
                        } else {
                            this.grid.set(currentColumn - 1, this.grid.get(currentColumn - 1) + 1);
                        }
                        if (currentColumn == columns) {
                            currentColumn = 1;
                            ++currentRow;
                        } else {
                            ++currentColumn;
                        }
                    } else if (isCosmetic) {
                        this.proxySlots.add(new ProxySlot(currentPage, (Slot)new CurioSlot(this.player, stackHandler, i, identifier, (currentColumn - 1) * 18 + 7 - this.panelWidth, yOffset + (currentRow - 1) * 18, stacksHandler.getRenders(), stacksHandler.canToggleRendering(), true, true)));
                    } else {
                        this.proxySlots.add(new ProxySlot(currentPage, (Slot)new CurioSlot(this.player, stackHandler, i, identifier, (currentColumn - 1) * 18 + 7 - this.panelWidth, yOffset + (currentRow - 1) * 18, stacksHandler.getRenders(), stacksHandler.canToggleRendering(), false, false)));
                    }
                    if (++slots >= maxSlotsPerPage) {
                        slots = 0;
                        ++currentPage;
                    }
                    ++index;
                }
            }
            if (!this.isLocalWorld) {
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)new SPacketPage(this.containerId, page), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        this.currentPage = page;
    }

    @Override
    public void resetSlots() {
        this.setPage(this.currentPage);
    }

    public void toggleCosmetics() {
        this.isViewingCosmetics = !this.isViewingCosmetics;
        this.resetSlots();
    }

    public void slotsChanged(@Nonnull Container inventoryIn) {
        if (!this.player.level().isClientSide) {
            ServerPlayer serverplayer = (ServerPlayer)this.player;
            ItemStack itemstack = ItemStack.EMPTY;
            Optional optional = Objects.requireNonNull(this.player.level().getServer()).getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)this.craftMatrix.asCraftInput(), this.player.level());
            if (optional.isPresent()) {
                ItemStack itemstack1;
                RecipeHolder recipeholder = (RecipeHolder)optional.get();
                CraftingRecipe craftingrecipe = (CraftingRecipe)recipeholder.value();
                if (this.craftResult.setRecipeUsed(this.player.level(), serverplayer, recipeholder) && (itemstack1 = craftingrecipe.assemble((RecipeInput)this.craftMatrix.asCraftInput(), (HolderLookup.Provider)this.player.level().registryAccess())).isItemEnabled(this.player.level().enabledFeatures())) {
                    itemstack = itemstack1;
                }
            }
            this.craftResult.setItem(0, itemstack);
            this.setRemoteSlot(0, itemstack);
            serverplayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), 0, itemstack));
        }
    }

    public void removed(@Nonnull Player playerIn) {
        super.removed(playerIn);
        this.craftResult.clearContent();
        if (!playerIn.level().isClientSide) {
            this.clearContainer(playerIn, (Container)this.craftMatrix);
        }
    }

    public void setItem(int pSlotId, int pStateId, @Nonnull ItemStack pStack) {
        if (this.slots.size() > pSlotId) {
            super.setItem(pSlotId, pStateId, pStack);
        }
    }

    public boolean stillValid(@Nonnull Player player) {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (!slot.hasItem()) return itemstack;
        ItemStack itemstack1 = slot.getItem();
        itemstack = itemstack1.copy();
        EquipmentSlot entityequipmentslot = playerIn.getEquipmentSlotForItem(itemstack);
        if (index == 0) {
            if (!this.moveItemStackTo(itemstack1, 9, 45, true)) {
                return ItemStack.EMPTY;
            }
            slot.onQuickCraft(itemstack1, itemstack);
        } else if (index < 5) {
            if (!this.moveItemStackTo(itemstack1, 9, 45, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 9) {
            if (!this.moveItemStackTo(itemstack1, 9, 45, false)) {
                return ItemStack.EMPTY;
            }
        } else if (entityequipmentslot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR && !((Slot)this.slots.get(8 - entityequipmentslot.getIndex())).hasItem()) {
            int i = 8 - entityequipmentslot.getIndex();
            if (!this.moveItemStackTo(itemstack1, i, i + 1, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index < 46 && !CuriosApi.getItemStackSlots(itemstack, playerIn.level()).isEmpty()) {
            if (!this.moveItemStackTo(itemstack1, 46, this.slots.size(), false)) {
                int page = this.findAvailableSlot(itemstack1);
                if (page == -1) return ItemStack.EMPTY;
                this.moveToPage = page;
                this.moveFromIndex = index;
            }
        } else if (entityequipmentslot == EquipmentSlot.OFFHAND && !((Slot)this.slots.get(45)).hasItem() ? !this.moveItemStackTo(itemstack1, 45, 46, false) : (index < 36 ? !this.moveItemStackTo(itemstack1, 36, 45, false) : (index < 45 ? !this.moveItemStackTo(itemstack1, 9, 36, false) : !this.moveItemStackTo(itemstack1, 9, 45, false)))) {
            return ItemStack.EMPTY;
        }
        if (itemstack1.isEmpty()) {
            slot.set(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        if (itemstack1.getCount() == itemstack.getCount()) {
            return ItemStack.EMPTY;
        }
        slot.onTake(playerIn, itemstack1);
        if (index != 0) return itemstack;
        playerIn.drop(itemstack1, false);
        return itemstack;
    }

    protected int findAvailableSlot(ItemStack stack) {
        int result = -1;
        if (stack.isStackable()) {
            for (ProxySlot proxySlot : this.proxySlots) {
                int maxSize;
                int j;
                Slot slot = proxySlot.slot();
                ItemStack itemstack = slot.getItem();
                if (itemstack.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)stack, (ItemStack)itemstack) || (j = itemstack.getCount() + stack.getCount()) > (maxSize = Math.min(slot.getMaxStackSize(), stack.getMaxStackSize())) && itemstack.getCount() >= maxSize) continue;
                result = proxySlot.page();
                break;
            }
        }
        if (!stack.isEmpty() && result == -1) {
            for (ProxySlot proxySlot : this.proxySlots) {
                Slot slot1 = proxySlot.slot();
                ItemStack itemstack1 = slot1.getItem();
                if (!itemstack1.isEmpty() || !slot1.mayPlace(stack)) continue;
                result = proxySlot.page();
                break;
            }
        }
        return result;
    }

    @Nonnull
    public RecipeBookType getRecipeBookType() {
        return RecipeBookType.CRAFTING;
    }

    public boolean shouldMoveToInventory(int index) {
        return index != this.getResultSlotIndex();
    }

    public void fillCraftSlotsStackedContents(@Nonnull StackedContents itemHelperIn) {
        this.craftMatrix.fillStackedContents(itemHelperIn);
    }

    public void clearCraftingContent() {
        this.craftMatrix.clearContent();
        this.craftResult.clearContent();
    }

    public boolean recipeMatches(RecipeHolder recipeHolder) {
        return recipeHolder.value().matches((RecipeInput)this.craftMatrix.asCraftInput(), this.player.level());
    }

    public int getResultSlotIndex() {
        return 0;
    }

    public int getGridWidth() {
        return this.craftMatrix.getWidth();
    }

    public int getGridHeight() {
        return this.craftMatrix.getHeight();
    }

    public int getSize() {
        return 5;
    }

    public void nextPage() {
        this.setPage(Math.min(this.currentPage + 1, this.totalPages - 1));
    }

    public void prevPage() {
        this.setPage(Math.max(this.currentPage - 1, 0));
    }

    public void checkQuickMove() {
        if (this.moveToPage != -1) {
            this.setPage(this.moveToPage);
            this.quickMoveStack(this.player, this.moveFromIndex);
            this.moveToPage = -1;
            if (!this.isLocalWorld) {
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)this.player), (CustomPacketPayload)new SPacketQuickMove(this.containerId, this.moveFromIndex), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @Nonnull
    public Slot getSlot(int index) {
        if (index < 0) {
            return super.getSlot(0);
        }
        if (index >= this.slots.size()) {
            return super.getSlot(this.slots.size() - 1);
        }
        return super.getSlot(index);
    }

    private record ProxySlot(int page, Slot slot) {
    }
}

