/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.forge.network;

import fr.rakambda.fallingtree.common.FallingTreeCommon;
import fr.rakambda.fallingtree.common.network.ClientPacketHandler;
import fr.rakambda.fallingtree.common.network.ConfigurationPacket;
import fr.rakambda.fallingtree.common.network.ServerPacketHandler;
import fr.rakambda.fallingtree.forge.FallingTreeUtils;
import fr.rakambda.fallingtree.forge.common.wrapper.FriendlyByteBufWrapper;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.ChannelBuilder;
import net.minecraftforge.network.SimpleChannel;

public class ForgePacketHandler
implements ClientPacketHandler,
ServerPacketHandler {
    public static final SimpleChannel INSTANCE = ChannelBuilder.named((ResourceLocation)FallingTreeUtils.id("main")).optional().simpleChannel();
    private static final int CONFIGURATION_MESSAGE_ID = 1;
    private final FallingTreeCommon<?> mod;

    @Override
    public void registerServer() {
        INSTANCE.messageBuilder(ConfigurationPacket.class, 1).decoder(buf -> ConfigurationPacket.read(new FriendlyByteBufWrapper((FriendlyByteBuf)buf))).encoder((packet, buf) -> packet.write(new FriendlyByteBufWrapper((FriendlyByteBuf)buf))).consumerMainThread(this::handleConfigurationPacket).add();
    }

    @Override
    public void registerClient() {
    }

    public void handleConfigurationPacket(ConfigurationPacket configurationPacket, CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.mod.getPacketUtils().onClientConfigurationPacket(configurationPacket)));
        context.setPacketHandled(true);
    }

    @Generated
    public ForgePacketHandler(FallingTreeCommon<?> mod) {
        this.mod = mod;
    }
}

