/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.fallingtree.common.config.proxy;

import fr.rakambda.fallingtree.common.config.IConfiguration;
import fr.rakambda.fallingtree.common.config.IEnchantmentConfiguration;
import fr.rakambda.fallingtree.common.config.IPlayerConfiguration;
import fr.rakambda.fallingtree.common.config.IResettable;
import fr.rakambda.fallingtree.common.config.enums.NotificationMode;
import fr.rakambda.fallingtree.common.config.enums.SneakMode;
import fr.rakambda.fallingtree.common.config.proxy.ToolProxyConfiguration;
import fr.rakambda.fallingtree.common.config.proxy.TreeProxyConfiguration;
import org.jetbrains.annotations.NotNull;

public class ProxyConfiguration
implements IConfiguration,
IResettable {
    private final IConfiguration delegate;
    private final ToolProxyConfiguration toolDelegate;
    private final TreeProxyConfiguration treeDelegate;

    public ProxyConfiguration(IConfiguration delegate) {
        this.delegate = delegate;
        this.toolDelegate = new ToolProxyConfiguration(delegate.getTools());
        this.treeDelegate = new TreeProxyConfiguration(delegate.getTrees());
    }

    @Override
    public void reset() {
        this.toolDelegate.reset();
        this.treeDelegate.reset();
    }

    @Override
    @NotNull
    public TreeProxyConfiguration getTrees() {
        return this.treeDelegate;
    }

    @Override
    @NotNull
    public ToolProxyConfiguration getTools() {
        return this.toolDelegate;
    }

    @Override
    @NotNull
    public IPlayerConfiguration getPlayer() {
        return this.delegate.getPlayer();
    }

    @Override
    @NotNull
    public IEnchantmentConfiguration getEnchantment() {
        return this.delegate.getEnchantment();
    }

    @Override
    @NotNull
    public SneakMode getSneakMode() {
        return this.delegate.getSneakMode();
    }

    @Override
    public boolean isBreakInCreative() {
        return this.delegate.isBreakInCreative();
    }

    @Override
    public boolean isLootInCreative() {
        return this.delegate.isLootInCreative();
    }

    @Override
    @NotNull
    public NotificationMode getNotificationMode() {
        return this.delegate.getNotificationMode();
    }
}

