/*
 * Decompiled with CFR 0.152.
 */
package dev.soncresityindustries.db;

import java.util.List;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="sidb")
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.ConfigValue<Integer> CONFIG_VERSION = BUILDER.comment("Config Version. DO NOT TOUCH UNDER ANY CIRCUMSTANCES!").define("configVersion", (Object)1);
    private static final ModConfigSpec.BooleanValue BOLT_VISUAL = BUILDER.comment("Whether the Lightning Bolt should only be visual and therefore should not damage entities or burn Items.").define("boltVisual", true);
    private static final ModConfigSpec.BooleanValue SOUND_GLOBAL = BUILDER.comment("Whether the Lightning Bolt should be heard from anywhere in the world or not.\n(Cannot be heard if a player is in a different dimension)").define("globalSound", false);
    private static final ModConfigSpec.ConfigValue<List<? extends String>> BLACKLISTED_WORLD_STRINGS = BUILDER.comment("Worlds in which a Lightning Bolt should NOT strike upon a player's death").defineListAllowEmpty("blacklistedWorlds", List.of(""), o -> o instanceof String);
    private static final ModConfigSpec.EnumValue<DeathAction> DEATH_ACTION = BUILDER.comment("What action should be taken upon a player's death?").defineEnum("deathAction", (Enum)DeathAction.MSG, (Enum[])DeathAction.values());
    private static final ModConfigSpec.EnumValue<MessageType> MESSAGE_TYPE = BUILDER.comment("What type of message should be sent upon a player's death?\nIMPORTANT: deathAction must be MSG").defineEnum("msgType", (Enum)MessageType.MSG_BROADCAST, (Enum[])MessageType.values());
    private static final ModConfigSpec.ConfigValue<String> PUNISH_MESSAGE = BUILDER.comment("Message to be sent upon a player's death.\nSupports Legacy Color Codes (\u00a7)\nAvailable Placeholders: {player}\nIMPORTANT: deathAction must either be KICK, BAN or MSG").define("punishMessage", (Object)"\u00a7c{player} died!");
    static final ModConfigSpec SPEC = BUILDER.build();
    public static int configVersion;
    public static boolean boltVisual;
    public static String[] blacklistedWorlds;
    public static String deathAction;
    public static String msgType;
    public static String punishMessage;
    public static boolean soundGlobal;

    @SubscribeEvent
    static void onLoad(ModConfigEvent.Loading event) {
        Config.changeValues();
    }

    @SubscribeEvent
    static void onReload(ModConfigEvent.Reloading event) {
        Config.changeValues();
    }

    private static void changeValues() {
        configVersion = (Integer)CONFIG_VERSION.get();
        boltVisual = (Boolean)BOLT_VISUAL.get();
        blacklistedWorlds = ((List)BLACKLISTED_WORLD_STRINGS.get()).toArray(new String[0]);
        deathAction = ((DeathAction)((Object)DEATH_ACTION.get())).toString();
        msgType = ((MessageType)((Object)MESSAGE_TYPE.get())).toString();
        punishMessage = (String)PUNISH_MESSAGE.get();
        soundGlobal = (Boolean)SOUND_GLOBAL.get();
    }

    protected static enum DeathAction {
        NONE,
        MSG,
        KICK,
        BAN;

    }

    protected static enum MessageType {
        MSG_PRIVATE,
        MSG_BROADCAST;

    }
}

