/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.world.raycast;

import java.util.function.BiFunction;
import java.util.function.Function;
import me.jellysquid.mods.lithium.common.util.Pos;
import me.jellysquid.mods.lithium.mixin.world.raycast.RaycastContextAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={BlockGetter.class})
public interface BlockViewMixin {
    @Shadow
    public BlockState getBlockState(BlockPos var1);

    @Shadow
    @Nullable
    public BlockHitResult clipWithInteractionOverride(Vec3 var1, Vec3 var2, BlockPos var3, VoxelShape var4, BlockState var5);

    @Shadow
    public static <T, C> T traverseBlocks(Vec3 start, Vec3 end, C context, BiFunction<C, BlockPos, T> blockHitFactory, Function<C, T> missFactory) {
        throw new AssertionError();
    }

    @Shadow
    public BlockHitResult lambda$clip$2(ClipContext var1, BlockPos var2);

    @Shadow
    public static BlockHitResult lambda$clip$3(ClipContext par1) {
        throw new AssertionError();
    }

    @Overwrite
    default public BlockHitResult clip(ClipContext context) {
        return BlockViewMixin.traverseBlocks(context.getFrom(), context.getTo(), context, this instanceof LevelReader ? this.blockHitFactory(context) : this::lambda$clip$2, BlockViewMixin::lambda$clip$3);
    }

    @Unique
    private BiFunction<ClipContext, BlockPos, BlockHitResult> blockHitFactory(final ClipContext context) {
        return new BiFunction<ClipContext, BlockPos, BlockHitResult>(){
            int chunkX = Integer.MIN_VALUE;
            int chunkZ = Integer.MIN_VALUE;
            ChunkAccess chunk = null;
            final boolean handleFluids = ((RaycastContextAccessor)context).getFluidHandling() != ClipContext.Fluid.NONE;

            @Override
            public BlockHitResult apply(ClipContext innerContext, BlockPos pos) {
                VoxelShape blockShape;
                Vec3 end;
                BlockState blockState = this.getBlock((LevelReader)BlockViewMixin.this, pos);
                Vec3 start = innerContext.getFrom();
                BlockHitResult blockHitResult = BlockViewMixin.this.clipWithInteractionOverride(start, end = innerContext.getTo(), pos, blockShape = innerContext.getBlockShape(blockState, (BlockGetter)BlockViewMixin.this, pos), blockState);
                double d = blockHitResult == null ? Double.MAX_VALUE : innerContext.getFrom().distanceToSqr(blockHitResult.getLocation());
                double e = Double.MAX_VALUE;
                BlockHitResult fluidHitResult = null;
                if (this.handleFluids) {
                    FluidState fluidState = blockState.getFluidState();
                    VoxelShape fluidShape = innerContext.getFluidShape(fluidState, (BlockGetter)BlockViewMixin.this, pos);
                    fluidHitResult = fluidShape.clip(start, end, pos);
                    e = fluidHitResult == null ? Double.MAX_VALUE : innerContext.getFrom().distanceToSqr(fluidHitResult.getLocation());
                }
                return d <= e ? blockHitResult : fluidHitResult;
            }

            private BlockState getBlock(LevelReader world, BlockPos blockPos) {
                LevelChunkSection section;
                ChunkAccess chunk;
                if (world.isOutsideBuildHeight(blockPos.getY())) {
                    return Blocks.VOID_AIR.defaultBlockState();
                }
                int chunkX = Pos.ChunkCoord.fromBlockCoord(blockPos.getX());
                int chunkZ = Pos.ChunkCoord.fromBlockCoord(blockPos.getZ());
                if (this.chunkX != chunkX || this.chunkZ != chunkZ) {
                    this.chunk = world.getChunk(chunkX, chunkZ);
                    this.chunkX = chunkX;
                    this.chunkZ = chunkZ;
                }
                if ((chunk = this.chunk) != null && (section = chunk.getSections()[Pos.SectionYIndex.fromBlockCoord((LevelHeightAccessor)chunk, blockPos.getY())]) != null && !section.hasOnlyAir()) {
                    return section.getBlockState(blockPos.getX() & 0xF, blockPos.getY() & 0xF, blockPos.getZ() & 0xF);
                }
                return Blocks.AIR.defaultBlockState();
            }
        };
    }
}

