/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.minimal_nonvanilla.world.expiring_chunk_tickets;

import com.llamalad7.mixinextras.sugar.Local;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.Collections;
import java.util.Iterator;
import me.jellysquid.mods.lithium.common.util.collections.ChunkTicketSortedArraySet;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.Ticket;
import net.minecraft.util.SortedArraySet;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={DistanceManager.class})
public abstract class ChunkTicketManagerMixin {
    @Shadow
    private long ticketTickCounter;
    @Shadow
    @Final
    Long2ObjectOpenHashMap<SortedArraySet<Ticket<?>>> tickets;
    private final Long2ObjectOpenHashMap<SortedArraySet<Ticket<?>>> positionWithExpiringTicket = new Long2ObjectOpenHashMap();

    private static boolean canNoneExpire(SortedArraySet<Ticket<?>> tickets) {
        if (!tickets.isEmpty()) {
            for (Ticket ticket : tickets) {
                if (!ChunkTicketManagerMixin.canExpire(ticket)) continue;
                return false;
            }
        }
        return true;
    }

    @Redirect(method={"lambda$addTicket$6(J)Lnet/minecraft/util/SortedArraySet;", "lambda$getTickets$7(J)Lnet/minecraft/util/SortedArraySet;"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/SortedArraySet;create(I)Lnet/minecraft/util/SortedArraySet;"))
    private static SortedArraySet<Ticket<?>> useLithiumSortedArraySet(int initialCapacity) {
        return new ChunkTicketSortedArraySet(initialCapacity);
    }

    private static boolean canExpire(Ticket<?> ticket) {
        return ticket.getType().timeout() != 0L;
    }

    @Inject(method={"addTicket(JLnet/minecraft/server/level/Ticket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/Ticket;setCreatedTick(J)V")})
    private void registerExpiringTicket(long position, Ticket<?> ticket, CallbackInfo ci, @Local SortedArraySet<Ticket<?>> ticketsAtPos) {
        if (ChunkTicketManagerMixin.canExpire(ticket)) {
            this.positionWithExpiringTicket.put(position, ticketsAtPos);
        }
    }

    @Inject(method={"removeTicket(JLnet/minecraft/server/level/Ticket;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/level/DistanceManager$ChunkTicketTracker;update(JIZ)V")})
    private void unregisterExpiringTicket(long pos, Ticket<?> ticket, CallbackInfo ci) {
        SortedArraySet ticketsAtPos;
        if (ChunkTicketManagerMixin.canExpire(ticket) && ChunkTicketManagerMixin.canNoneExpire(ticketsAtPos = (SortedArraySet)this.positionWithExpiringTicket.get(pos))) {
            this.positionWithExpiringTicket.remove(pos);
        }
    }

    @Inject(method={"addTicket(JLnet/minecraft/server/level/Ticket;)V"}, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/util/SortedArraySet;addOrGet(Ljava/lang/Object;)Ljava/lang/Object;")})
    private void updateSetMinExpiryTime(long position, Ticket<?> ticket, CallbackInfo ci, @Local(ordinal=0) SortedArraySet<?> sortedArraySet) {
        if (ChunkTicketManagerMixin.canExpire(ticket) && sortedArraySet instanceof ChunkTicketSortedArraySet) {
            ChunkTicketSortedArraySet chunkTickets = (ChunkTicketSortedArraySet)sortedArraySet;
            chunkTickets.addExpireTime(this.ticketTickCounter + ticket.getType().timeout());
        }
    }

    @Redirect(method={"purgeStaleTickets()V"}, at=@At(value="FIELD", target="Lnet/minecraft/server/level/DistanceManager;tickets:Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", ordinal=0))
    private Long2ObjectOpenHashMap<SortedArraySet<Ticket<?>>> getExpiringTicketsByPosition(DistanceManager chunkTicketManager) {
        return this.positionWithExpiringTicket;
    }

    @Redirect(method={"purgeStaleTickets()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/SortedArraySet;isEmpty()Z"))
    private boolean retCanNoneExpire(SortedArraySet<Ticket<?>> tickets) {
        return ChunkTicketManagerMixin.canNoneExpire(tickets);
    }

    @Inject(method={"purgeStaleTickets()V"}, locals=LocalCapture.CAPTURE_FAILHARD, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/util/SortedArraySet;isEmpty()Z")})
    private void removeIfEmpty(CallbackInfo ci, ObjectIterator<?> objectIterator, Long2ObjectMap.Entry<SortedArraySet<Ticket<?>>> entry) {
        SortedArraySet ticketsAtPos = (SortedArraySet)entry.getValue();
        if (ticketsAtPos.isEmpty()) {
            this.tickets.remove(entry.getLongKey(), (Object)ticketsAtPos);
        }
    }

    @Redirect(method={"purgeStaleTickets()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/SortedArraySet;iterator()Ljava/util/Iterator;"))
    private Iterator<Ticket<?>> skipIfNotExpiringNow(SortedArraySet<Ticket<?>> ticketsAtPos) {
        ChunkTicketSortedArraySet optimizedSet;
        if (ticketsAtPos instanceof ChunkTicketSortedArraySet && (optimizedSet = (ChunkTicketSortedArraySet)ticketsAtPos).getMinExpireTime() > this.ticketTickCounter) {
            return Collections.emptyIterator();
        }
        return ticketsAtPos.iterator();
    }
}

