/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.entity.equipment_tracking.equipment_changes;

import java.util.Map;
import me.jellysquid.mods.lithium.common.entity.EquipmentEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity
implements EquipmentEntity.EquipmentTrackingEntity {
    @Unique
    private boolean equipmentChanged = true;

    public LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Override
    public void lithium$onEquipmentChanged() {
        this.equipmentChanged = true;
    }

    @Inject(method={"collectEquipmentChanges()Ljava/util/Map;"}, at={@At(value="HEAD")}, cancellable=true)
    private void skipSentEquipmentComparison(CallbackInfoReturnable<@Nullable Map<EquipmentSlot, ItemStack>> cir) {
        if (!this.equipmentChanged) {
            cir.setReturnValue(null);
        }
    }

    @Inject(method={"detectEquipmentUpdates()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;handleHandSwap(Ljava/util/Map;)V")})
    private void resetEquipmentChanged(CallbackInfo ci) {
        if (!(this instanceof Player)) {
            this.equipmentChanged = false;
        }
    }
}

