/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.entity.equipment_tracking;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import me.jellysquid.mods.lithium.common.entity.EquipmentEntity;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Mob.class})
public abstract class MobEntityMixin
extends Entity
implements EquipmentEntity {
    @Shadow
    private ItemStack bodyArmorItem;

    public MobEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @WrapOperation(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/core/NonNullList;set(ILjava/lang/Object;)Ljava/lang/Object;")}, require=2)
    private <E> E trackEquipChange(NonNullList<E> list, int index, E element, Operation<E> original) {
        Object prevElement = original.call(new Object[]{list, index, element});
        this.trackEquipChange(prevElement, element);
        return (E)prevElement;
    }

    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="HEAD"), @At(value="RETURN")})
    private void trackBodyArmor(CompoundTag nbt, CallbackInfo ci, @Share(value="prevBodyArmor") LocalRef<ItemStack> prevBodyArmorRef) {
        ItemStack prevBodyArmor = (ItemStack)prevBodyArmorRef.get();
        if (prevBodyArmor == null) {
            prevBodyArmorRef.set((Object)this.bodyArmorItem);
        } else if (prevBodyArmor != this.bodyArmorItem) {
            this.trackEquipChange(prevBodyArmor, this.bodyArmorItem);
        }
    }

    @Unique
    private <E> void trackEquipChange(E prevElement, E element) {
        if (!this.level().isClientSide() && element instanceof ItemStack) {
            ItemStack newStack = (ItemStack)element;
            if (prevElement instanceof ItemStack) {
                ItemStack prevStack = (ItemStack)prevElement;
                this.lithium$onEquipmentReplaced(prevStack, newStack);
            }
        }
    }
}

