/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.entity.collisions.movement;

import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import java.util.ArrayList;
import java.util.List;
import me.jellysquid.mods.lithium.common.entity.LithiumEntityCollisions;
import me.jellysquid.mods.lithium.common.entity.movement.ChunkAwareBlockCollisionSweeper;
import me.jellysquid.mods.lithium.common.util.collections.LazyList;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    public abstract Level level();

    @Shadow
    public abstract AABB getBoundingBox();

    @Redirect(method={"collide(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getEntityCollisions(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/AABB;)Ljava/util/List;"))
    private List<VoxelShape> postponeGetEntities(Level world, Entity entity, AABB box, @Share(value="requireAddEntities") LocalBooleanRef requireAddEntities) {
        requireAddEntities.set(true);
        return new ArrayList<VoxelShape>();
    }

    @Redirect(method={"collide(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;collideBoundingBox(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Lnet/minecraft/world/level/Level;Ljava/util/List;)Lnet/minecraft/world/phys/Vec3;"))
    private Vec3 collideMovementWithPostponedGetEntities(@Nullable Entity entity, Vec3 movement, AABB entityBoundingBox, Level world, List<VoxelShape> entityCollisions, @Share(value="requireAddEntities") LocalBooleanRef requireAddEntities) {
        return EntityMixin.lithium$CollideMovement(entity, movement, entityBoundingBox, world, entityCollisions, requireAddEntities);
    }

    @ModifyVariable(method={"collide(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"}, at=@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/world/entity/Entity;collectColliders(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/level/Level;Ljava/util/List;Lnet/minecraft/world/phys/AABB;)Ljava/util/List;"))
    private List<VoxelShape> collectEntities(List<VoxelShape> entityCollisions, @Share(value="requireAddEntities") LocalBooleanRef requireAddEntities) {
        if (requireAddEntities.get()) {
            requireAddEntities.set(false);
            ArrayList<Object> collisions = entityCollisions instanceof ArrayList ? (ArrayList<Object>)entityCollisions : new ArrayList<VoxelShape>(entityCollisions);
            LithiumEntityCollisions.appendEntityCollisions((List<VoxelShape>)collisions, this.level(), (Entity)this, this.getBoundingBox());
            return collisions;
        }
        return entityCollisions;
    }

    @Overwrite
    public static Vec3 collideBoundingBox(@Nullable Entity entity, Vec3 movement, AABB entityBoundingBox, Level world, List<VoxelShape> entityCollisions) {
        return EntityMixin.lithium$CollideMovement(entity, movement, entityBoundingBox, world, entityCollisions, null);
    }

    @Unique
    private static Vec3 lithium$CollideMovement(@Nullable Entity entity, Vec3 movement, AABB entityBoundingBox, Level world, List<VoxelShape> entityCollisions, LocalBooleanRef requireAddEntities) {
        boolean zMovementBiggerThanXMovement;
        double v;
        VoxelShape voxelShape;
        boolean isSingleAxisMovement;
        double movementX = movement.x;
        double movementY = movement.y;
        double movementZ = movement.z;
        boolean bl = isSingleAxisMovement = (movementX == 0.0 ? 0 : 1) + (movementY == 0.0 ? 0 : 1) + (movementZ == 0.0 ? 0 : 1) == 1;
        if (movementY < 0.0 && (voxelShape = LithiumEntityCollisions.getSupportingCollisionForEntity(world, entity, entityBoundingBox)) != null && (v = voxelShape.collide(Direction.Axis.Y, entityBoundingBox, movementY)) == 0.0) {
            if (isSingleAxisMovement) {
                return Vec3.ZERO;
            }
            movementY = 0.0;
            isSingleAxisMovement = (movementX == 0.0 ? 0 : 1) + (movementZ == 0.0 ? 0 : 1) == 1;
        }
        AABB movementSpace = isSingleAxisMovement ? LithiumEntityCollisions.getSmallerBoxForSingleAxisMovement(movement, entityBoundingBox, movementY, movementX, movementZ) : entityBoundingBox.expandTowards(movement);
        boolean shouldAddEntities = requireAddEntities != null && requireAddEntities.get();
        boolean shouldAddWorldBorder = true;
        boolean shouldAddLastBlock = true;
        ChunkAwareBlockCollisionSweeper blockCollisionSweeper = new ChunkAwareBlockCollisionSweeper(world, entity, movementSpace, true);
        LazyList blockCollisions = new LazyList(new ArrayList(), blockCollisionSweeper);
        ArrayList<VoxelShape> worldBorderAndLastBlockCollision = new ArrayList<VoxelShape>(2);
        if (movementY != 0.0 && (movementY = Shapes.collide((Direction.Axis)Direction.Axis.Y, (AABB)entityBoundingBox, blockCollisions, (double)movementY)) != 0.0) {
            shouldAddEntities = LithiumEntityCollisions.addEntityCollisionsIfRequired(shouldAddEntities, entity, world, entityCollisions, movementSpace);
            shouldAddWorldBorder = LithiumEntityCollisions.addWorldBorderCollisionIfRequired(shouldAddWorldBorder, entity, worldBorderAndLastBlockCollision, movementSpace);
            shouldAddLastBlock = LithiumEntityCollisions.addLastBlockCollisionIfRequired(shouldAddLastBlock, blockCollisionSweeper, worldBorderAndLastBlockCollision);
            if (!entityCollisions.isEmpty()) {
                movementY = Shapes.collide((Direction.Axis)Direction.Axis.Y, (AABB)entityBoundingBox, entityCollisions, (double)movementY);
            }
            if (!worldBorderAndLastBlockCollision.isEmpty()) {
                movementY = Shapes.collide((Direction.Axis)Direction.Axis.Y, (AABB)entityBoundingBox, worldBorderAndLastBlockCollision, (double)movementY);
            }
            if (movementY != 0.0) {
                entityBoundingBox = entityBoundingBox.move(0.0, movementY, 0.0);
            }
        }
        boolean bl2 = zMovementBiggerThanXMovement = Math.abs(movementX) < Math.abs(movementZ);
        if (zMovementBiggerThanXMovement && (movementZ = Shapes.collide((Direction.Axis)Direction.Axis.Z, (AABB)entityBoundingBox, blockCollisions, (double)movementZ)) != 0.0) {
            shouldAddEntities = LithiumEntityCollisions.addEntityCollisionsIfRequired(shouldAddEntities, entity, world, entityCollisions, movementSpace);
            shouldAddWorldBorder = LithiumEntityCollisions.addWorldBorderCollisionIfRequired(shouldAddWorldBorder, entity, worldBorderAndLastBlockCollision, movementSpace);
            shouldAddLastBlock = LithiumEntityCollisions.addLastBlockCollisionIfRequired(shouldAddLastBlock, blockCollisionSweeper, worldBorderAndLastBlockCollision);
            if (!entityCollisions.isEmpty()) {
                movementZ = Shapes.collide((Direction.Axis)Direction.Axis.Z, (AABB)entityBoundingBox, entityCollisions, (double)movementZ);
            }
            if (!worldBorderAndLastBlockCollision.isEmpty()) {
                movementZ = Shapes.collide((Direction.Axis)Direction.Axis.Z, (AABB)entityBoundingBox, worldBorderAndLastBlockCollision, (double)movementZ);
            }
            if (movementZ != 0.0) {
                entityBoundingBox = entityBoundingBox.move(0.0, 0.0, movementZ);
            }
        }
        if (movementX != 0.0 && (movementX = Shapes.collide((Direction.Axis)Direction.Axis.X, (AABB)entityBoundingBox, blockCollisions, (double)movementX)) != 0.0) {
            shouldAddEntities = LithiumEntityCollisions.addEntityCollisionsIfRequired(shouldAddEntities, entity, world, entityCollisions, movementSpace);
            shouldAddWorldBorder = LithiumEntityCollisions.addWorldBorderCollisionIfRequired(shouldAddWorldBorder, entity, worldBorderAndLastBlockCollision, movementSpace);
            shouldAddLastBlock = LithiumEntityCollisions.addLastBlockCollisionIfRequired(shouldAddLastBlock, blockCollisionSweeper, worldBorderAndLastBlockCollision);
            if (!entityCollisions.isEmpty()) {
                movementX = Shapes.collide((Direction.Axis)Direction.Axis.X, (AABB)entityBoundingBox, entityCollisions, (double)movementX);
            }
            if (!worldBorderAndLastBlockCollision.isEmpty()) {
                movementX = Shapes.collide((Direction.Axis)Direction.Axis.X, (AABB)entityBoundingBox, worldBorderAndLastBlockCollision, (double)movementX);
            }
            if (movementX != 0.0) {
                entityBoundingBox = entityBoundingBox.move(movementX, 0.0, 0.0);
            }
        }
        if (!zMovementBiggerThanXMovement && movementZ != 0.0 && (movementZ = Shapes.collide((Direction.Axis)Direction.Axis.Z, (AABB)entityBoundingBox, blockCollisions, (double)movementZ)) != 0.0) {
            shouldAddEntities = LithiumEntityCollisions.addEntityCollisionsIfRequired(shouldAddEntities, entity, world, entityCollisions, movementSpace);
            shouldAddWorldBorder = LithiumEntityCollisions.addWorldBorderCollisionIfRequired(shouldAddWorldBorder, entity, worldBorderAndLastBlockCollision, movementSpace);
            shouldAddLastBlock = LithiumEntityCollisions.addLastBlockCollisionIfRequired(shouldAddLastBlock, blockCollisionSweeper, worldBorderAndLastBlockCollision);
            if (!entityCollisions.isEmpty()) {
                movementZ = Shapes.collide((Direction.Axis)Direction.Axis.Z, (AABB)entityBoundingBox, entityCollisions, (double)movementZ);
            }
            if (!worldBorderAndLastBlockCollision.isEmpty()) {
                movementZ = Shapes.collide((Direction.Axis)Direction.Axis.Z, (AABB)entityBoundingBox, worldBorderAndLastBlockCollision, (double)movementZ);
            }
        }
        if (requireAddEntities != null && !shouldAddEntities) {
            requireAddEntities.set(false);
        }
        return new Vec3(movementX, movementY, movementZ);
    }
}

