/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.chunk.serialization;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.LongStream;
import me.jellysquid.mods.lithium.common.world.chunk.CompactingPackedIntegerArray;
import me.jellysquid.mods.lithium.common.world.chunk.LithiumHashPalette;
import net.minecraft.core.IdMap;
import net.minecraft.util.BitStorage;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.util.ZeroBitStorage;
import net.minecraft.world.level.chunk.Palette;
import net.minecraft.world.level.chunk.PaletteResize;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PalettedContainer.class})
public abstract class PalettedContainerMixin<T> {
    private static final ThreadLocal<short[]> CACHED_ARRAY_4096 = ThreadLocal.withInitial(() -> new short[4096]);
    private static final ThreadLocal<short[]> CACHED_ARRAY_64 = ThreadLocal.withInitial(() -> new short[64]);
    @Shadow
    private volatile PalettedContainer.Data<T> data;
    @Shadow
    @Final
    private PaletteResize<T> dummyPaletteResize;

    @Shadow
    public abstract void acquire();

    @Shadow
    protected abstract T get(int var1);

    @Shadow
    public abstract void release();

    @Overwrite
    public PalettedContainerRO.PackedData<T> pack(IdMap<T> idList, PalettedContainer.Strategy provider) {
        this.acquire();
        LithiumHashPalette hashPalette = null;
        Optional<Object> data = Optional.empty();
        List<Object> elements = null;
        Palette palette = this.data.palette();
        BitStorage storage = this.data.storage();
        if (storage instanceof ZeroBitStorage || palette.getSize() == 1) {
            elements = List.of(palette.valueFor(0));
        } else if (palette instanceof LithiumHashPalette) {
            LithiumHashPalette lithiumHashPalette;
            hashPalette = lithiumHashPalette = (LithiumHashPalette)palette;
        }
        if (elements == null) {
            LithiumHashPalette<T> compactedPalette = new LithiumHashPalette<T>(idList, storage.getBits(), this.dummyPaletteResize);
            short[] array = this.getOrCreate(provider.size());
            ((CompactingPackedIntegerArray)storage).lithium$compact(this.data.palette(), compactedPalette, array);
            if (hashPalette != null && hashPalette.getSize() == compactedPalette.getSize() && storage.getBits() == provider.calculateBitsForSerialization(idList, hashPalette.getSize())) {
                data = this.asOptional((long[])storage.getRaw().clone());
                elements = hashPalette.getElements();
            } else {
                int bits = provider.calculateBitsForSerialization(idList, compactedPalette.getSize());
                if (bits != 0) {
                    SimpleBitStorage copy = new SimpleBitStorage(bits, array.length);
                    for (int i = 0; i < array.length; ++i) {
                        copy.set(i, (int)array[i]);
                    }
                    data = this.asOptional(copy.getRaw());
                }
                elements = compactedPalette.getElements();
            }
        }
        this.release();
        return new PalettedContainerRO.PackedData(elements, data);
    }

    private Optional<LongStream> asOptional(long[] data) {
        return Optional.of(Arrays.stream(data));
    }

    private short[] getOrCreate(int size) {
        return switch (size) {
            case 64 -> CACHED_ARRAY_64.get();
            case 4096 -> CACHED_ARRAY_4096.get();
            default -> new short[size];
        };
    }

    @Inject(method={"count(Lnet/minecraft/world/level/chunk/PalettedContainer$CountConsumer;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void count(PalettedContainer.CountConsumer<T> consumer, CallbackInfo ci) {
        int len = this.data.palette().getSize();
        if (len > 4096) {
            return;
        }
        short[] counts = new short[len];
        this.data.storage().getAll(i -> {
            int n = i;
            counts[n] = (short)(counts[n] + 1);
        });
        for (int i2 = 0; i2 < counts.length; ++i2) {
            Object obj = this.data.palette().valueFor(i2);
            if (obj == null) continue;
            consumer.accept(obj, (int)counts[i2]);
        }
        ci.cancel();
    }
}

