/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.mixin.ai.poi;

import com.google.common.collect.AbstractIterator;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import me.jellysquid.mods.lithium.common.util.Pos;
import me.jellysquid.mods.lithium.common.util.collections.ListeningLong2ObjectOpenHashMap;
import me.jellysquid.mods.lithium.common.world.interests.RegionBasedStorageSectionExtended;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.storage.ChunkIOErrorReporter;
import net.minecraft.world.level.chunk.storage.SectionStorage;
import net.minecraft.world.level.chunk.storage.SimpleRegionStorage;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SectionStorage.class})
public abstract class SerializingRegionBasedStorageMixin<R>
implements RegionBasedStorageSectionExtended<R> {
    @Mutable
    @Shadow
    @Final
    private Long2ObjectMap<Optional<R>> storage;
    @Shadow
    @Final
    protected LevelHeightAccessor levelHeightAccessor;
    private Long2ObjectOpenHashMap<BitSet> columns;

    @Shadow
    protected abstract Optional<R> getOrLoad(long var1);

    @Shadow
    protected abstract void readColumn(ChunkPos var1);

    @Inject(method={"<init>(Lnet/minecraft/world/level/chunk/storage/SimpleRegionStorage;Ljava/util/function/Function;Ljava/util/function/Function;Lnet/minecraft/core/RegistryAccess;Lnet/minecraft/world/level/chunk/storage/ChunkIOErrorReporter;Lnet/minecraft/world/level/LevelHeightAccessor;)V"}, at={@At(value="RETURN")})
    private void init(SimpleRegionStorage storageAccess, Function codecFactory, Function factory, RegistryAccess registryManager, ChunkIOErrorReporter errorHandler, LevelHeightAccessor world, CallbackInfo ci) {
        this.columns = new Long2ObjectOpenHashMap();
        this.storage = new ListeningLong2ObjectOpenHashMap<Optional>(this::onEntryAdded, this::onEntryRemoved);
    }

    private void onEntryRemoved(long key, Optional<R> value) {
        int z;
        int y = Pos.SectionYIndex.fromSectionCoord(this.levelHeightAccessor, SectionPos.y((long)key));
        if (y < 0 || y >= Pos.SectionYIndex.getNumYSections(this.levelHeightAccessor)) {
            return;
        }
        int x = SectionPos.x((long)key);
        long pos = ChunkPos.asLong((int)x, (int)(z = SectionPos.z((long)key)));
        BitSet flags = (BitSet)this.columns.get(pos);
        if (flags != null) {
            flags.clear(y);
            if (flags.isEmpty()) {
                this.columns.remove(pos);
            }
        }
    }

    private void onEntryAdded(long key, Optional<R> value) {
        int z;
        int y = Pos.SectionYIndex.fromSectionCoord(this.levelHeightAccessor, SectionPos.y((long)key));
        if (y < 0 || y >= Pos.SectionYIndex.getNumYSections(this.levelHeightAccessor)) {
            return;
        }
        int x = SectionPos.x((long)key);
        long pos = ChunkPos.asLong((int)x, (int)(z = SectionPos.z((long)key)));
        BitSet flags = (BitSet)this.columns.get(pos);
        if (flags == null) {
            flags = new BitSet(Pos.SectionYIndex.getNumYSections(this.levelHeightAccessor));
            this.columns.put(pos, (Object)flags);
        }
        flags.set(y, value.isPresent());
    }

    @Override
    public Stream<R> lithium$getWithinChunkColumn(int chunkX, int chunkZ) {
        BitSet sectionsWithPOI = this.getNonEmptyPOISections(chunkX, chunkZ);
        if (sectionsWithPOI.isEmpty()) {
            return Stream.empty();
        }
        ArrayList list = new ArrayList();
        int minYSection = Pos.SectionYCoord.getMinYSection(this.levelHeightAccessor);
        int chunkYIndex = sectionsWithPOI.nextSetBit(0);
        while (chunkYIndex != -1) {
            int chunkY = chunkYIndex + minYSection;
            Object r = ((Optional)this.storage.get(SectionPos.asLong((int)chunkX, (int)chunkY, (int)chunkZ))).orElse(null);
            if (r != null) {
                list.add(r);
            }
            chunkYIndex = sectionsWithPOI.nextSetBit(chunkYIndex + 1);
        }
        return list.stream();
    }

    @Override
    public Iterable<R> lithium$getInChunkColumn(final int chunkX, final int chunkZ) {
        final BitSet sectionsWithPOI = this.getNonEmptyPOISections(chunkX, chunkZ);
        if (sectionsWithPOI.isEmpty()) {
            return Collections::emptyIterator;
        }
        final Long2ObjectMap<Optional<R>> loadedElements = this.storage;
        final LevelHeightAccessor world = this.levelHeightAccessor;
        return () -> new AbstractIterator<R>(this){
            private int nextBit;
            {
                this.nextBit = sectionsWithPOI.nextSetBit(0);
            }

            protected R computeNext() {
                while (this.nextBit >= 0) {
                    Optional next = (Optional)loadedElements.get(SectionPos.asLong((int)chunkX, (int)Pos.SectionYCoord.fromSectionIndex(world, this.nextBit), (int)chunkZ));
                    this.nextBit = sectionsWithPOI.nextSetBit(this.nextBit + 1);
                    if (!next.isPresent()) continue;
                    return next.get();
                }
                return this.endOfData();
            }
        };
    }

    private BitSet getNonEmptyPOISections(int chunkX, int chunkZ) {
        long pos = ChunkPos.asLong((int)chunkX, (int)chunkZ);
        BitSet flags = this.getNonEmptySections(pos, false);
        if (flags != null) {
            return flags;
        }
        this.readColumn(new ChunkPos(pos));
        return this.getNonEmptySections(pos, true);
    }

    private BitSet getNonEmptySections(long pos, boolean required) {
        BitSet set = (BitSet)this.columns.get(pos);
        if (set == null && required) {
            throw new NullPointerException("No data is present for column: " + String.valueOf(new ChunkPos(pos)));
        }
        return set;
    }
}

