/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.entity.movement_tracker;

import java.util.ArrayList;
import java.util.List;
import me.jellysquid.mods.lithium.common.entity.movement_tracker.SectionedEntityMovementTracker;
import me.jellysquid.mods.lithium.common.util.tuples.WorldSectionBox;
import me.jellysquid.mods.lithium.common.world.LithiumData;
import me.jellysquid.mods.lithium.mixin.block.hopper.EntityTrackingSectionAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ClassInstanceMultiMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class SectionedItemEntityMovementTracker<S extends Entity>
extends SectionedEntityMovementTracker<Entity, S> {
    public SectionedItemEntityMovementTracker(WorldSectionBox worldSectionBox, Class<S> clazz) {
        super(worldSectionBox, clazz);
    }

    public static <S extends Entity> SectionedItemEntityMovementTracker<S> registerAt(ServerLevel world, AABB interactionArea, Class<S> clazz) {
        WorldSectionBox worldSectionBox = WorldSectionBox.entityAccessBox((Level)world, interactionArea);
        SectionedItemEntityMovementTracker<S> tracker = new SectionedItemEntityMovementTracker<S>(worldSectionBox, clazz);
        tracker = ((LithiumData)world).lithium$getData().entityMovementTrackers().getCanonical(tracker);
        tracker.register(world);
        return tracker;
    }

    public List<S> getEntities(AABB interactionArea) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (int sectionIndex = 0; sectionIndex < this.sortedSections.size(); ++sectionIndex) {
            if (!this.sectionVisible[sectionIndex]) continue;
            ClassInstanceMultiMap collection = ((EntityTrackingSectionAccessor)this.sortedSections.get(sectionIndex)).getCollection();
            for (Entity entity : collection.find(this.clazz)) {
                AABB entityBoundingBox;
                if (!entity.isAlive() || !(entityBoundingBox = entity.getBoundingBox()).intersects(interactionArea)) continue;
                entities.add(entity);
            }
        }
        return entities;
    }
}

