/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.entity.movement_tracker;

import java.util.ArrayList;
import java.util.List;
import me.jellysquid.mods.lithium.common.entity.movement_tracker.SectionedEntityMovementTracker;
import me.jellysquid.mods.lithium.common.util.tuples.WorldSectionBox;
import me.jellysquid.mods.lithium.common.world.LithiumData;
import me.jellysquid.mods.lithium.mixin.block.hopper.EntityTrackingSectionAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ClassInstanceMultiMap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class SectionedInventoryEntityMovementTracker<S>
extends SectionedEntityMovementTracker<Entity, S> {
    public SectionedInventoryEntityMovementTracker(WorldSectionBox entityAccessBox, Class<S> clazz) {
        super(entityAccessBox, clazz);
    }

    public static <S> SectionedInventoryEntityMovementTracker<S> registerAt(ServerLevel world, AABB interactionArea, Class<S> clazz) {
        WorldSectionBox worldSectionBox = WorldSectionBox.entityAccessBox((Level)world, interactionArea);
        SectionedInventoryEntityMovementTracker<S> tracker = new SectionedInventoryEntityMovementTracker<S>(worldSectionBox, clazz);
        tracker = ((LithiumData)world).lithium$getData().entityMovementTrackers().getCanonical(tracker);
        tracker.register(world);
        return tracker;
    }

    public List<S> getEntities(AABB box) {
        ArrayList entities = new ArrayList();
        for (int i = 0; i < this.sortedSections.size(); ++i) {
            if (!this.sectionVisible[i]) continue;
            ClassInstanceMultiMap collection = ((EntityTrackingSectionAccessor)this.sortedSections.get(i)).getCollection();
            for (Object entity : collection.find(this.clazz)) {
                Entity inventoryEntity = (Entity)entity;
                if (!inventoryEntity.isAlive() || !inventoryEntity.getBoundingBox().intersects(box)) continue;
                entities.add(entity);
            }
        }
        return entities;
    }
}

