/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration.step;

import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.gridList.ArrayGridList;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject.DhLitWorldGenRegion;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration.params.ThreadWorldGenParams;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration.step.AbstractWorldGenStep;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;

public final class StepStructureStart
extends AbstractWorldGenStep {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final ChunkStatus STATUS = ChunkStatus.STRUCTURE_STARTS;
    private static final ReentrantLock STRUCTURE_PLACEMENT_LOCK = new ReentrantLock();
    private final BatchGenerationEnvironment environment;

    public StepStructureStart(BatchGenerationEnvironment batchGenerationEnvironment) {
        this.environment = batchGenerationEnvironment;
    }

    @Override
    public ChunkStatus getChunkStatus() {
        return STATUS;
    }

    @Override
    public void generateGroup(ThreadWorldGenParams tParams, DhLitWorldGenRegion worldGenRegion, ArrayGridList<ChunkWrapper> chunkWrappers) {
        ArrayList<ChunkWrapper> chunksToDo = this.getChunkWrappersToGenerate(chunkWrappers);
        if (!this.environment.globalParams.worldOptions.generateStructures()) {
            return;
        }
        for (ChunkWrapper chunkWrapper : chunksToDo) {
            ChunkAccess chunk = chunkWrapper.getChunk();
            STRUCTURE_PLACEMENT_LOCK.lock();
            this.environment.globalParams.generator.createStructures(this.environment.globalParams.registry, this.environment.globalParams.mcServerLevel.getChunkSource().getGeneratorState(), (StructureManager)tParams.structFeatManager, chunk, this.environment.globalParams.structures);
            try {
                tParams.structCheck.onStructureLoad(chunk.getPos(), chunk.getAllStarts());
            }
            catch (ArrayIndexOutOfBoundsException firstEx) {
                tParams.recreateStructureCheck();
                try {
                    tParams.structCheck.onStructureLoad(chunk.getPos(), chunk.getAllStarts());
                }
                catch (ArrayIndexOutOfBoundsException secondEx) {
                    LOGGER.error("Unable to create structure starts for " + String.valueOf(chunk.getPos()) + ". This is an error with MC's world generation. Ignoring and continuing generation. Error: " + secondEx.getMessage(), new Object[0]);
                }
            }
            STRUCTURE_PLACEMENT_LOCK.unlock();
        }
    }
}

