/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.minecraft;

import com.mojang.blaze3d.systems.RenderSystem;
import com.seibel.distanthorizons.api.enums.config.EDhApiLodShading;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.math.Vec3d;
import com.seibel.distanthorizons.core.util.math.Vec3f;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.ILightMapWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.AbstractOptifineAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IDimensionTypeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.awt.Color;
import java.util.concurrent.ConcurrentHashMap;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.McObjectConverter;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.misc.LightMapWrapper;
import net.minecraft.class_1011;
import net.minecraft.class_1294;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_5636;
import net.minecraft.class_638;
import net.minecraft.class_758;
import org.jetbrains.annotations.NotNull;

public class MinecraftRenderWrapper
implements IMinecraftRenderWrapper {
    public static final MinecraftRenderWrapper INSTANCE = new MinecraftRenderWrapper();
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final class_310 MC = class_310.method_1551();
    public ConcurrentHashMap<IDimensionTypeWrapper, LightMapWrapper> lightmapByDimensionType = new ConcurrentHashMap();
    public int finalLevelFrameBufferId = -1;
    public boolean colorTextureCastFailLogged = false;
    public boolean depthTextureCastFailLogged = false;

    @Override
    public Vec3f getLookAtVector() {
        class_4184 camera = MinecraftRenderWrapper.MC.field_1773.method_19418();
        return new Vec3f(camera.method_19335().x(), camera.method_19335().y(), camera.method_19335().z());
    }

    @Override
    public boolean playerHasBlindingEffect() {
        if (MinecraftRenderWrapper.MC.field_1724 == null) {
            return false;
        }
        if (MinecraftRenderWrapper.MC.field_1724.method_6088() == null) {
            return false;
        }
        return MinecraftRenderWrapper.MC.field_1724.method_6088().get(class_1294.field_5919) != null || MinecraftRenderWrapper.MC.field_1724.method_6088().get(class_1294.field_38092) != null;
    }

    @Override
    public Vec3d getCameraExactPosition() {
        class_4184 camera = MinecraftRenderWrapper.MC.field_1773.method_19418();
        class_243 projectedView = camera.method_19326();
        return new Vec3d(projectedView.field_1352, projectedView.field_1351, projectedView.field_1350);
    }

    @Override
    public Color getFogColor(float partialTicks) {
        class_758.method_3210((class_4184)MinecraftRenderWrapper.MC.field_1773.method_19418(), (float)partialTicks, (class_638)MinecraftRenderWrapper.MC.field_1687, (int)1, (float)MinecraftRenderWrapper.MC.field_1773.method_3195(partialTicks));
        float[] colorValues = RenderSystem.getShaderFogColor();
        return new Color(Math.max(0.0f, Math.min(colorValues[0], 1.0f)), Math.max(0.0f, Math.min(colorValues[1], 1.0f)), Math.max(0.0f, Math.min(colorValues[2], 1.0f)), Math.max(0.0f, Math.min(colorValues[3], 1.0f)));
    }

    @Override
    public Color getSkyColor() {
        if (MinecraftRenderWrapper.MC.field_1687.method_8597().comp_642()) {
            float frameTime = MC.method_60646().method_60638();
            class_243 colorValues = MinecraftRenderWrapper.MC.field_1687.method_23777(MinecraftRenderWrapper.MC.field_1773.method_19418().method_19326(), frameTime);
            return new Color((float)colorValues.field_1352, (float)colorValues.field_1351, (float)colorValues.field_1350);
        }
        return new Color(0, 0, 0);
    }

    @Override
    public double getFov(float partialTicks) {
        return MinecraftRenderWrapper.MC.field_1773.method_3196(MinecraftRenderWrapper.MC.field_1773.method_19418(), partialTicks, true);
    }

    @Override
    public int getRenderDistance() {
        return MinecraftRenderWrapper.MC.field_1690.method_38521();
    }

    protected class_276 getRenderTarget() {
        return MC.method_1522();
    }

    @Override
    public boolean mcRendersToFrameBuffer() {
        return true;
    }

    @Override
    public boolean runningLegacyOpenGL() {
        return false;
    }

    @Override
    public int getTargetFramebuffer() {
        if (AbstractOptifineAccessor.optifinePresent()) {
            return this.finalLevelFrameBufferId;
        }
        return this.getRenderTarget().field_1476;
    }

    @Override
    public void clearTargetFrameBuffer() {
        this.finalLevelFrameBufferId = -1;
    }

    @Override
    public int getDepthTextureId() {
        return this.getRenderTarget().method_30278();
    }

    @Override
    public int getColorTextureId() {
        return this.getRenderTarget().method_30277();
    }

    @Override
    public int getTargetFramebufferViewportWidth() {
        return this.getRenderTarget().field_1480;
    }

    @Override
    public int getTargetFramebufferViewportHeight() {
        return this.getRenderTarget().field_1477;
    }

    @Override
    public ILightMapWrapper getLightmapWrapper(@NotNull ILevelWrapper level) {
        return this.lightmapByDimensionType.get(level.getDimensionType());
    }

    @Override
    public boolean isFogStateSpecial() {
        boolean isBlind = this.playerHasBlindingEffect();
        return MinecraftRenderWrapper.MC.field_1773.method_19418().method_19334() != class_5636.field_27888 || isBlind;
    }

    public void updateLightmap(class_1011 lightPixels, IClientLevelWrapper level) {
        IDimensionTypeWrapper dimensionType = level.getDimensionType();
        LightMapWrapper wrapper = this.lightmapByDimensionType.computeIfAbsent(dimensionType, dimType -> new LightMapWrapper());
        wrapper.uploadLightmap(lightPixels);
    }

    public void setLightmapId(int tetxureId, IClientLevelWrapper level) {
        IDimensionTypeWrapper dimensionType = level.getDimensionType();
        LightMapWrapper wrapper = this.lightmapByDimensionType.computeIfAbsent(dimensionType, dimType -> new LightMapWrapper());
        wrapper.setLightmapId(tetxureId);
    }

    @Override
    public float getShade(EDhDirection lodDirection) {
        EDhApiLodShading lodShading = Config.Client.Advanced.Graphics.Quality.lodShading.get();
        switch (lodShading) {
            default: {
                if (MinecraftRenderWrapper.MC.field_1687 != null) {
                    class_2350 mcDir = McObjectConverter.Convert(lodDirection);
                    return MinecraftRenderWrapper.MC.field_1687.method_24852(mcDir, true);
                }
                return 0.0f;
            }
            case ENABLED: {
                switch (lodDirection) {
                    case DOWN: {
                        return 0.5f;
                    }
                    default: {
                        return 1.0f;
                    }
                    case NORTH: 
                    case SOUTH: {
                        return 0.8f;
                    }
                    case WEST: 
                    case EAST: 
                }
                return 0.6f;
            }
            case DISABLED: 
        }
        return 1.0f;
    }
}

