/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render;

import com.seibel.distanthorizons.api.DhApi;
import com.seibel.distanthorizons.api.interfaces.override.rendering.IDhApiCullingFrustum;
import com.seibel.distanthorizons.api.interfaces.override.rendering.IDhApiShadowCullingFrustum;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.LodBufferContainer;
import com.seibel.distanthorizons.core.dependencyInjection.ModAccessorInjector;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.logging.f3.F3Screen;
import com.seibel.distanthorizons.core.pos.DhLodPos;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.Pos2D;
import com.seibel.distanthorizons.core.render.DhFrustumBounds;
import com.seibel.distanthorizons.core.render.LodQuadTree;
import com.seibel.distanthorizons.core.render.LodRenderSection;
import com.seibel.distanthorizons.core.render.NeverCullFrustum;
import com.seibel.distanthorizons.core.render.renderer.RenderParams;
import com.seibel.distanthorizons.core.util.math.Mat4f;
import com.seibel.distanthorizons.core.util.math.Vec3d;
import com.seibel.distanthorizons.core.util.objects.SortedArraySet;
import com.seibel.distanthorizons.core.util.objects.quadTree.QuadNode;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftGLWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IIrisAccessor;
import java.util.Iterator;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class RenderBufferHandler
implements AutoCloseable {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    private static final IMinecraftGLWrapper GLMC = SingletonInjector.INSTANCE.get(IMinecraftGLWrapper.class);
    private static final IIrisAccessor IRIS_ACCESSOR = ModAccessorInjector.INSTANCE.get(IIrisAccessor.class);
    public final LodQuadTree lodQuadTree;
    private final SortedArraySet<LodBufferContainer> loadedNearToFarBuffers;
    private int visibleBufferCount;
    private int culledBufferCount;
    private int shadowVisibleBufferCount;
    private int shadowCulledBufferCount;

    public RenderBufferHandler(LodQuadTree lodQuadTree) {
        IDhApiShadowCullingFrustum coreShadowFrustum;
        this.lodQuadTree = lodQuadTree;
        IDhApiCullingFrustum coreCameraFrustum = DhApi.overrides.get(IDhApiCullingFrustum.class, -1);
        if (coreCameraFrustum == null) {
            DhApi.overrides.bind(IDhApiCullingFrustum.class, new DhFrustumBounds());
        }
        if ((coreShadowFrustum = DhApi.overrides.get(IDhApiShadowCullingFrustum.class, -1)) == null) {
            DhApi.overrides.bind(IDhApiShadowCullingFrustum.class, new NeverCullFrustum());
        }
        this.loadedNearToFarBuffers = new SortedArraySet(this::sortBufferContainersNearToFar);
    }

    private int sortBufferContainersNearToFar(LodBufferContainer loadedBufferA, LodBufferContainer loadedBufferB) {
        Pos2D aPos = DhSectionPos.getCenterBlockPos(loadedBufferA.pos).toPos2D();
        Pos2D bPos = DhSectionPos.getCenterBlockPos(loadedBufferB.pos).toPos2D();
        Pos2D centerPos = this.lodQuadTree.getCenterBlockPos().toPos2D();
        int aManhattanDistance = aPos.manhattanDist(centerPos);
        int bManhattanDistance = bPos.manhattanDist(centerPos);
        return aManhattanDistance - bManhattanDistance;
    }

    public void buildRenderList(RenderParams renderParams) {
        IDhApiCullingFrustum frustum;
        boolean enableFrustumCulling;
        boolean isShadowPass;
        this.loadedNearToFarBuffers.clear();
        boolean bl = isShadowPass = IRIS_ACCESSOR != null && IRIS_ACCESSOR.isRenderingShadowPass();
        if (isShadowPass) {
            enableFrustumCulling = Config.Client.Advanced.Graphics.Culling.disableShadowPassFrustumCulling.get() == false;
            frustum = DhApi.overrides.get(IDhApiShadowCullingFrustum.class);
        } else {
            enableFrustumCulling = Config.Client.Advanced.Graphics.Culling.disableFrustumCulling.get() == false;
            frustum = DhApi.overrides.get(IDhApiCullingFrustum.class);
        }
        if (enableFrustumCulling) {
            int worldMinY = renderParams.clientLevelWrapper.getMinHeight();
            int worldHeight = renderParams.clientLevelWrapper.getMaxHeight();
            Vec3d cameraPos = MC_RENDER.getCameraExactPosition();
            Matrix4f matWorldView = new Matrix4f().setTransposed(renderParams.mcModelViewMatrix.getValuesAsArray()).translate(-((float)cameraPos.x), -((float)cameraPos.y), -((float)cameraPos.z));
            Matrix4f matWorldViewProjection = new Matrix4f().setTransposed(renderParams.dhProjectionMatrix.getValuesAsArray()).mul((Matrix4fc)matWorldView);
            frustum.update(worldMinY, worldMinY + worldHeight, new Mat4f((Matrix4fc)matWorldViewProjection));
        }
        if (isShadowPass) {
            this.shadowCulledBufferCount = 0;
        } else {
            this.culledBufferCount = 0;
        }
        Iterator nodeIterator = this.lodQuadTree.nodeIteratorWithStoppingFilter(node -> {
            if (node == null) {
                return true;
            }
            LodRenderSection renderSection = (LodRenderSection)node.value;
            if (renderSection == null) {
                return false;
            }
            try {
                int lodBlockWidth;
                int blockMinZ;
                DhLodPos lodBounds;
                int blockMinX;
                if (enableFrustumCulling && !frustum.intersects(blockMinX = (lodBounds = DhSectionPos.getSectionBBoxPos(renderSection.pos)).getMinX().toBlockWidth(), blockMinZ = lodBounds.getMinZ().toBlockWidth(), lodBlockWidth = lodBounds.getBlockWidth(), lodBounds.detailLevel)) {
                    if (isShadowPass) {
                        ++this.shadowCulledBufferCount;
                    } else {
                        ++this.culledBufferCount;
                    }
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                LOGGER.error("Unexpected issue during culling for node pos: [" + DhSectionPos.toString(node.sectionPos) + "], error: [" + e.getMessage() + "].", e);
                return false;
            }
        });
        while (nodeIterator.hasNext()) {
            QuadNode node2 = nodeIterator.next();
            long sectionPos = node2.sectionPos;
            LodRenderSection renderSection = (LodRenderSection)node2.value;
            if (renderSection == null) continue;
            try {
                LodBufferContainer bufferContainer = renderSection.bufferContainer;
                if (bufferContainer == null || !renderSection.getRenderingEnabled()) continue;
                this.loadedNearToFarBuffers.add(bufferContainer);
            }
            catch (Exception e) {
                LOGGER.error("Error updating QuadTree render source at [" + DhSectionPos.toString(renderSection.pos) + "], error: [" + e.getMessage() + "].", e);
            }
        }
        if (isShadowPass) {
            this.shadowVisibleBufferCount = this.loadedNearToFarBuffers.size();
        } else {
            this.visibleBufferCount = this.loadedNearToFarBuffers.size();
        }
    }

    public SortedArraySet<LodBufferContainer> getColumnRenderBuffers() {
        return this.loadedNearToFarBuffers;
    }

    public String getVboRenderDebugMenuString() {
        String countText = F3Screen.NUMBER_FORMAT.format(this.visibleBufferCount);
        if (!Config.Client.Advanced.Graphics.Culling.disableFrustumCulling.get().booleanValue()) {
            countText = countText + "/" + F3Screen.NUMBER_FORMAT.format(this.visibleBufferCount + this.culledBufferCount);
        }
        return "VBO Render Count: [" + countText + "]";
    }

    public String getShadowPassRenderDebugMenuString() {
        boolean hasIrisShaders;
        boolean bl = hasIrisShaders = IRIS_ACCESSOR != null && IRIS_ACCESSOR.isShaderPackInUse();
        if (!hasIrisShaders) {
            return null;
        }
        String countText = F3Screen.NUMBER_FORMAT.format(this.shadowVisibleBufferCount);
        if (!Config.Client.Advanced.Graphics.Culling.disableFrustumCulling.get().booleanValue()) {
            countText = countText + "/" + F3Screen.NUMBER_FORMAT.format(this.shadowVisibleBufferCount + this.shadowCulledBufferCount);
        }
        return "Shadow VBO Render Count: [" + countText + "]";
    }

    @Override
    public void close() {
        this.lodQuadTree.close();
    }
}

