/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.mixins;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import dev.wendigodrip.thebrokenscript.api.TBSConstants;
import dev.wendigodrip.thebrokenscript.api.misc.CapeLoader;
import dev.wendigodrip.thebrokenscript.api.util.FileHelper;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={AbstractClientPlayer.class})
public abstract class AbstractClientPlayerMixin {
    @Shadow
    @Nullable
    protected abstract PlayerInfo getPlayerInfo();

    @ModifyReturnValue(method={"getSkin"}, at={@At(value="RETURN")})
    private PlayerSkin getCapeTexture(PlayerSkin original) {
        ResourceLocation id;
        PlayerInfo playerInfo = this.getPlayerInfo();
        if (playerInfo == null) {
            return original;
        }
        String fileName = CapeLoader.getCapes().get(playerInfo.getProfile().getId());
        if (fileName != null && FileHelper.fileExists(id = TBSConstants.id("textures/cape/" + fileName + ".png"))) {
            return new PlayerSkin(original.texture(), original.textureUrl(), id, original.elytraTexture(), original.model(), original.secure());
        }
        return original;
    }
}

