/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.handlers;

import dev.wendigodrip.thebrokenscript.api.TBSConstants;
import dev.wendigodrip.thebrokenscript.api.ext.LevelExt;
import dev.wendigodrip.thebrokenscript.vars.MapVariables;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\f"}, d2={"Ldev/wendigodrip/thebrokenscript/handlers/MoonTextureChanger;", "", "<init>", "()V", "moonPhasesLoc", "Lnet/minecraft/resources/ResourceLocation;", "kotlin.jvm.PlatformType", "Lnet/minecraft/resources/ResourceLocation;", "onLevelTick", "", "event", "Lnet/neoforged/neoforge/event/tick/LevelTickEvent$Post;", "thebrokenscript"})
public final class MoonTextureChanger {
    @NotNull
    public static final MoonTextureChanger INSTANCE = new MoonTextureChanger();
    private static final ResourceLocation moonPhasesLoc = ResourceLocation.parse((String)"minecraft:textures/environment/moon_phases.png");

    private MoonTextureChanger() {
    }

    @SubscribeEvent
    public final void onLevelTick(@NotNull LevelTickEvent.Post event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!event.getLevel().isClientSide) {
            return;
        }
        Level level = event.getLevel();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"getLevel(...)");
        MapVariables vars = LevelExt.INSTANCE.getVars((LevelAccessor)level);
        TextureManager texMgr = Minecraft.getInstance().getTextureManager();
        if (vars.getMoonPhase() > 0 && vars.getMoonPhase() < 3) {
            texMgr.bindForSetup(TBSConstants.id("textures/moonevent/moon_phases" + vars.getMoonPhase() + ".png"));
            texMgr.register(moonPhasesLoc, texMgr.getTexture(TBSConstants.id("textures/moonevent/moon_phases" + vars.getMoonPhase() + ".png")));
        } else {
            texMgr.bindForSetup(moonPhasesLoc);
            texMgr.register(moonPhasesLoc, (AbstractTexture)new SimpleTexture(moonPhasesLoc));
        }
    }
}

