/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.handlers;

import dev.wendigodrip.thebrokenscript.api.ext.LevelExt;
import dev.wendigodrip.thebrokenscript.api.ext.PlayerExt;
import dev.wendigodrip.thebrokenscript.api.util.Vectors;
import dev.wendigodrip.thebrokenscript.registry.TBSParticleTypes;
import dev.wendigodrip.thebrokenscript.registry.TBSTags;
import dev.wendigodrip.thebrokenscript.vars.PlayerVariables;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Ldev/wendigodrip/thebrokenscript/handlers/CreepyDiscHandler;", "", "<init>", "()V", "onRightClickBlock", "", "event", "Lnet/neoforged/neoforge/event/entity/player/PlayerInteractEvent$RightClickBlock;", "thebrokenscript"})
public final class CreepyDiscHandler {
    @NotNull
    public static final CreepyDiscHandler INSTANCE = new CreepyDiscHandler();

    private CreepyDiscHandler() {
    }

    @SubscribeEvent
    public final void onRightClickBlock(@NotNull PlayerInteractEvent.RightClickBlock event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getHand() != event.getEntity().getUsedItemHand()) {
            return;
        }
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Intrinsics.checkNotNull((Object)player);
        PlayerVariables vars = PlayerExt.INSTANCE.getVars(player);
        if (!(level instanceof ServerLevel)) {
            return;
        }
        if (!player.getMainHandItem().is(TBSTags.CREEPY_DISCS)) {
            return;
        }
        if (((ServerLevel)level).getBlockState(event.getHitVec().getBlockPos()).is(Blocks.JUKEBOX)) {
            vars.setHasPlayedCreepyDisc(true);
            vars.syncTo(player);
            ServerLevel serverLevel = (ServerLevel)level;
            Supplier supplier = (Supplier)TBSParticleTypes.NULL_PARTICLE;
            Vec3 vec3 = pos.getCenter();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
            LevelExt.INSTANCE.sendParticles(serverLevel, supplier, vec3, (Number)40, Vectors.INSTANCE.all(3), (Number)0);
        }
    }
}

