/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.handlers;

import dev.wendigodrip.thebrokenscript.api.ext.EntityFinder;
import dev.wendigodrip.thebrokenscript.entity.circuit.CircuitStalkEntity;
import dev.wendigodrip.thebrokenscript.entity.circuit.CircuitStareEntity;
import dev.wendigodrip.thebrokenscript.registry.TBSTags;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import org.jetbrains.annotations.NotNull;

@EventBusSubscriber
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Ldev/wendigodrip/thebrokenscript/handlers/CircuitDespawner;", "", "<init>", "()V", "onEntitySpawned", "", "event", "Lnet/neoforged/neoforge/event/entity/EntityJoinLevelEvent;", "thebrokenscript"})
public final class CircuitDespawner {
    @NotNull
    public static final CircuitDespawner INSTANCE = new CircuitDespawner();

    private CircuitDespawner() {
    }

    @SubscribeEvent
    public final void onEntitySpawned(@NotNull EntityJoinLevelEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Entity entity = event.getEntity();
        Level level = event.getLevel();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        if (entity.getType().is(TBSTags.DESPAWNABLE)) {
            LevelAccessor levelAccessor = (LevelAccessor)level;
            Vec3 vec3 = entity.position();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
            Class[] classArray = new Class[]{CircuitStalkEntity.class, CircuitStareEntity.class};
            if (EntityFinder.INSTANCE.hasEntitiesInRange(levelAccessor, vec3, 2000, classArray)) {
                event.setCanceled(true);
            }
        }
    }
}

