/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.events.sounds;

import dev.wendigodrip.thebrokenscript.api.event.BaseEvent;
import dev.wendigodrip.thebrokenscript.api.ext.BoundingBoxExt;
import dev.wendigodrip.thebrokenscript.api.ext.LevelExt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\f"}, d2={"Ldev/wendigodrip/thebrokenscript/events/sounds/DoorsEvent;", "Ldev/wendigodrip/thebrokenscript/api/event/BaseEvent;", "<init>", "()V", "execute", "", "level", "Lnet/minecraft/server/level/ServerLevel;", "player", "Lnet/minecraft/server/level/ServerPlayer;", "pos", "Lnet/minecraft/world/phys/Vec3;", "thebrokenscript"})
public final class DoorsEvent
extends BaseEvent {
    public DoorsEvent() {
        super(1);
    }

    @Override
    protected void execute(@NotNull ServerLevel level, @NotNull ServerPlayer player, @NotNull Vec3 pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        boolean found = false;
        BlockPos doorPos = BlockPos.containing((Position)((Position)pos));
        BoundingBox boundingBox = new BoundingBox(BlockPos.containing((Position)((Position)pos))).inflatedBy(3);
        Intrinsics.checkNotNullExpressionValue((Object)boundingBox, (String)"inflatedBy(...)");
        for (BlockPos pos2 : BoundingBoxExt.INSTANCE.getPositions(boundingBox)) {
            if (!level.getBlockState(pos2).is(BlockTags.WOODEN_DOORS)) continue;
            found = true;
            doorPos = pos2;
            break;
        }
        if (found) {
            LevelAccessor levelAccessor = (LevelAccessor)level;
            SoundEvent soundEvent = SoundEvents.WOODEN_DOOR_OPEN;
            Intrinsics.checkNotNullExpressionValue((Object)soundEvent, (String)"WOODEN_DOOR_OPEN");
            LevelExt.playSound$default(LevelExt.INSTANCE, levelAccessor, pos, soundEvent, 55.0f, 1.0f, null, 16, null);
            player.level().getBlockState(doorPos).useItemOn(player.getItemInHand(InteractionHand.MAIN_HAND), player.level(), (Player)player, InteractionHand.MAIN_HAND, BlockHitResult.miss((Vec3)new Vec3((double)doorPos.getX(), (double)doorPos.getY(), (double)doorPos.getZ()), (Direction)Direction.UP, (BlockPos)doorPos));
        }
    }
}

