/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.entity.tbe;

import dev.wendigodrip.thebrokenscript.TheBrokenScript;
import dev.wendigodrip.thebrokenscript.api.entity.FinalizedSpawn;
import dev.wendigodrip.thebrokenscript.api.entity.base.UwuableMonster;
import dev.wendigodrip.thebrokenscript.api.ext.AttributesExt;
import dev.wendigodrip.thebrokenscript.api.ext.BoundingBoxExt;
import dev.wendigodrip.thebrokenscript.api.ext.DamageSourcesExt;
import dev.wendigodrip.thebrokenscript.api.ext.EntityExt;
import dev.wendigodrip.thebrokenscript.api.ext.EntityFinder;
import dev.wendigodrip.thebrokenscript.api.ext.EntityTypeExt;
import dev.wendigodrip.thebrokenscript.api.ext.LevelExt;
import dev.wendigodrip.thebrokenscript.api.ext.PlayerExt;
import dev.wendigodrip.thebrokenscript.api.ext.TagExt;
import dev.wendigodrip.thebrokenscript.api.util.BlockBreakHelper;
import dev.wendigodrip.thebrokenscript.api.util.Boxes;
import dev.wendigodrip.thebrokenscript.api.world.TimeOfDay;
import dev.wendigodrip.thebrokenscript.config.TBSConfigs;
import dev.wendigodrip.thebrokenscript.registry.TBSEntities;
import dev.wendigodrip.thebrokenscript.registry.TBSLang;
import dev.wendigodrip.thebrokenscript.registry.TBSSounds;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0001(B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J4\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0005\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J \u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0011H\u0016J\b\u0010$\u001a\u00020\nH\u0016J\u0014\u0010%\u001a\u00020&2\n\u0010\u001c\u001a\u0006\u0012\u0002\b\u00030'H\u0016\u00a8\u0006)"}, d2={"Ldev/wendigodrip/thebrokenscript/entity/tbe/TheBrokenEndEntity;", "Ldev/wendigodrip/thebrokenscript/api/entity/base/UwuableMonster;", "Ldev/wendigodrip/thebrokenscript/api/entity/FinalizedSpawn;", "type", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "registerGoals", "", "removeWhenFarAway", "", "distanceToClosestPlayer", "", "hurt", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "amount", "", "onFinalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnType", "Lnet/minecraft/world/entity/MobSpawnType;", "spawnData", "event", "Lnet/neoforged/neoforge/event/entity/living/FinalizeSpawnEvent;", "awardKillScore", "entity", "Lnet/minecraft/world/entity/Entity;", "score", "", "damageSource", "baseTick", "movementPredicate", "Lsoftware/bernie/geckolib/animation/PlayState;", "Lsoftware/bernie/geckolib/animation/AnimationState;", "Companion", "thebrokenscript"})
@SourceDebugExtension(value={"SMAP\nTheBrokenEndEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TheBrokenEndEntity.kt\ndev/wendigodrip/thebrokenscript/entity/tbe/TheBrokenEndEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,254:1\n1755#2,3:255\n*S KotlinDebug\n*F\n+ 1 TheBrokenEndEntity.kt\ndev/wendigodrip/thebrokenscript/entity/tbe/TheBrokenEndEntity\n*L\n102#1:255,3\n*E\n"})
public final class TheBrokenEndEntity
extends UwuableMonster
implements FinalizedSpawn {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public TheBrokenEndEntity(@NotNull EntityType<TheBrokenEndEntity> type, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(type, level);
        this.xpReward = 5440;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Entity entity = source.getEntity();
            if (entity != null) {
                entity.hurt(this.level().damageSources().playerAttack(null), 10.0f);
            }
            Object[] objectArray = new ResourceKey[]{DamageTypes.IN_FIRE, DamageTypes.FALL, DamageTypes.CACTUS, DamageTypes.DROWN, DamageTypes.LIGHTNING_BOLT, DamageTypes.EXPLOSION, DamageTypes.TRIDENT, DamageTypes.FALLING_ANVIL, DamageTypes.DRAGON_BREATH, DamageTypes.WITHER, DamageTypes.WITHER_SKULL};
            List blacklistedDamageTypes = CollectionsKt.listOf((Object[])objectArray);
            Iterable $this$any$iv = blacklistedDamageTypes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ResourceKey it = (ResourceKey)element$iv;
                    boolean bl2 = false;
                    if (!source.is(it)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        if (source.getDirectEntity() instanceof AbstractArrow || source.getDirectEntity() instanceof Player || source.getDirectEntity() instanceof ThrownPotion || source.getDirectEntity() instanceof AreaEffectCloud) {
            return false;
        }
        return super.hurt(source, amount);
    }

    @Override
    @Nullable
    public SpawnGroupData onFinalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @NotNull FinalizeSpawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnType, (String)"spawnType");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        LevelAccessor levelAccessor = (LevelAccessor)level;
        Vec3 vec3 = new Vec3(this.getX(), this.getY(), this.getZ());
        Object object = TBSSounds.THE_END_IS_NEAR.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        LevelExt.playSound$default(LevelExt.INSTANCE, levelAccessor, vec3, (SoundEvent)object, 555.0f, 1.0f, null, 16, null);
        TimeOfDay.MIDNIGHT.setFake();
        EntityExt.INSTANCE.discardNearest(Boat.class, new Vec3(this.getX(), this.getY(), this.getZ()), (Level)level, 1000.0);
        this.teleportTo(this.getX(), this.getY(), this.getZ());
        TheBrokenScript.INSTANCE.queueServerWork$thebrokenscript(1000, () -> TheBrokenEndEntity.onFinalizeSpawn$lambda$1(this));
        return null;
    }

    public void awardKillScore(@NotNull Entity entity, int score, @NotNull DamageSource damageSource) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        super.awardKillScore(entity, score, damageSource);
        Level level = this.level();
        Intrinsics.checkNotNull((Object)level);
        LevelAccessor levelAccessor = (LevelAccessor)level;
        Vec3 vec3 = new Vec3(this.getX(), this.getY(), this.getZ());
        Object object = TBSSounds.NULL_KILLS_PLAYER.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        LevelExt.playSound$default(LevelExt.INSTANCE, levelAccessor, vec3, (SoundEvent)object, 1.0f, 1.0f, null, 16, null);
        if (!(level instanceof ServerLevel)) {
            return;
        }
        this.discard();
        ServerPlayer serverPlayer = EntityFinder.INSTANCE.findClosestPlayerInRange((ServerLevel)level, new Vec3(this.getX(), this.getY(), this.getZ()), (Number)400.0);
        if (serverPlayer != null && (serverPlayer = serverPlayer.connection) != null) {
            serverPlayer.disconnect((Component)TBSLang.INSTANCE.getTBE_KICK());
        }
        if (!TBSConfigs.COMMON.getDisableBanning()) {
            Object object2 = TBSEntities.getBAN().get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            EntityType entityType = (EntityType)object2;
            LevelAccessor levelAccessor2 = (LevelAccessor)level;
            BlockPos blockPos = BlockPos.containing((double)this.getX(), (double)this.getY(), (double)this.getZ());
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"containing(...)");
            EntityExt.INSTANCE.applyRandomRotation(EntityTypeExt.INSTANCE.trySummon(entityType, levelAccessor2, blockPos));
        }
    }

    public void baseTick() {
        double interferences;
        super.baseTick();
        Level level = this.level();
        BlockPos pos = this.blockPosition();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Vec3 vec3 = pos.getCenter();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
        ServerPlayer player = EntityFinder.INSTANCE.findClosestPlayerInRange(serverLevel, vec3, (Number)400.0);
        if (player == null) {
            return;
        }
        player.setGameMode(GameType.SURVIVAL);
        this.setTarget((LivingEntity)player);
        int heights = pos.getY() + this.random.nextInt(1, 8);
        BlockBreakHelper.INSTANCE.tryBreakCircuit((LevelAccessor)level, new BlockPos(pos.getX() + 1, heights, pos.getZ()));
        BlockBreakHelper.INSTANCE.tryBreakCircuit((LevelAccessor)level, new BlockPos(pos.getX() - 1, heights, pos.getZ()));
        BlockBreakHelper.INSTANCE.tryBreakCircuit((LevelAccessor)level, new BlockPos(pos.getX(), heights, pos.getZ() + 1));
        BlockBreakHelper.INSTANCE.tryBreakCircuit((LevelAccessor)level, new BlockPos(pos.getX(), heights, pos.getZ() - 1));
        CompoundTag compoundTag = this.getPersistentData();
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"getPersistentData(...)");
        double a = TagExt.INSTANCE.addDouble(compoundTag, "a", 1.0);
        if (a > 100.0) {
            ServerPlayer[] serverPlayerArray;
            this.getPersistentData().putDouble("a", 0.0);
            Object object = TBSSounds.THE_END_IS_NEAR.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            PlayerExt.sendSound$default(PlayerExt.INSTANCE, player, (SoundEvent)object, 555.0f, 0.0f, null, null, 0L, 56, null);
            if ((double)this.random.nextFloat() < 0.7) {
                player.lookAt(EntityAnchorArgument.Anchor.EYES, pos.above(5).getCenter());
            }
            if ((double)this.random.nextFloat() < 0.7) {
                serverPlayerArray = new ServerPlayer[]{player};
                TimeOfDay.MIDNIGHT.setFake(serverPlayerArray);
                PlayerExt.INSTANCE.trySendOverlay((Player)player, "textures/screens/frame1.png", 10);
            }
            if ((double)this.random.nextFloat() < 0.7) {
                serverPlayerArray = new ServerPlayer[]{player};
                TimeOfDay.DAY.setFake(serverPlayerArray);
                PlayerExt.INSTANCE.trySendOverlay((Player)player, "textures/screens/frame2.png", 10);
            }
            if ((double)this.random.nextFloat() < 0.7) {
                serverPlayerArray = new ServerPlayer[]{player};
                TimeOfDay.DAY.setFake(serverPlayerArray);
                PlayerExt.INSTANCE.trySendOverlay((Player)player, "textures/screens/wecanhearyou.png", 10);
            }
        }
        LevelAccessor levelAccessor = (LevelAccessor)level;
        Vec3 vec32 = pos.getCenter();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getCenter(...)");
        IronGolem ironGolem = EntityFinder.INSTANCE.findClosestEntityInRange(levelAccessor, IronGolem.class, vec32, 20);
        if (ironGolem != null) {
            DamageSources damageSources = ((ServerLevel)level).damageSources();
            Intrinsics.checkNotNullExpressionValue((Object)damageSources, (String)"damageSources(...)");
            ironGolem.hurt(DamageSourcesExt.INSTANCE.player(damageSources), 30.0f);
        }
        LevelAccessor levelAccessor2 = (LevelAccessor)level;
        Vec3 vec33 = pos.getCenter();
        Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"getCenter(...)");
        Boat boat = EntityFinder.INSTANCE.findClosestEntityInRange(levelAccessor2, Boat.class, vec33, 20);
        if (boat != null) {
            DamageSources damageSources = ((ServerLevel)level).damageSources();
            Intrinsics.checkNotNullExpressionValue((Object)damageSources, (String)"damageSources(...)");
            boat.hurt(DamageSourcesExt.INSTANCE.player(damageSources), 30.0f);
        }
        CompoundTag compoundTag2 = this.getPersistentData();
        Intrinsics.checkNotNullExpressionValue((Object)compoundTag2, (String)"getPersistentData(...)");
        double d = interferences = TagExt.INSTANCE.incDouble(compoundTag2, "interferences");
        if (d == 3.0) {
            PlayerExt.INSTANCE.trySendOverlay((Player)player, "textures/screens/dotscreenframe1.png", 5);
        } else if (d == 6.0) {
            PlayerExt.INSTANCE.trySendOverlay((Player)player, "textures/screens/dotscreenframe2.png", 5);
        } else if (d == 9.0) {
            PlayerExt.INSTANCE.trySendOverlay((Player)player, "textures/screens/dotscreenframe3.png", 5);
        } else if (d == 12.0) {
            PlayerExt.INSTANCE.trySendOverlay((Player)player, "textures/screens/dotscreenframe4.png", 5);
            this.getPersistentData().putDouble("interferences", 0.0);
        }
        if (((ServerLevel)level).getBlockState(pos).canOcclude()) {
            this.teleportTo(pos.getCenter().x, pos.getCenter().y + 1.0, pos.getCenter().z);
        }
        this.lookAt(EntityAnchorArgument.Anchor.EYES, pos.offset(0, 1, 0).getCenter());
        player.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 10, 1, false, false));
        player.addEffect(new MobEffectInstance(MobEffects.DIG_SLOWDOWN, 10, 1, false, false));
        Intrinsics.checkNotNull((Object)pos);
        BoundingBoxExt.INSTANCE.forEachPos(Boxes.INSTANCE.bounding(pos, 9), (Function1<? super BlockPos, Unit>)((Function1)arg_0 -> TheBrokenEndEntity.baseTick$lambda$2(level, arg_0)));
        this.refreshDimensions();
    }

    @Override
    @NotNull
    public PlayState movementPredicate(@NotNull AnimationState<?> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        if (Intrinsics.areEqual((Object)this.getAnimProcedure(), (Object)"empty")) {
            if (event.isMoving() || !(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
                PlayState playState = event.setAndContinue(RawAnimation.begin().thenLoop("run"));
                Intrinsics.checkNotNullExpressionValue((Object)playState, (String)"setAndContinue(...)");
                return playState;
            }
            PlayState playState = event.setAndContinue(RawAnimation.begin().thenLoop("idle1"));
            Intrinsics.checkNotNullExpressionValue((Object)playState, (String)"setAndContinue(...)");
            return playState;
        }
        return PlayState.STOP;
    }

    @Override
    public void callFinalizeSpawn(@NotNull FinalizeSpawnEvent event) {
        FinalizedSpawn.DefaultImpls.callFinalizeSpawn(this, event);
    }

    private static final void onFinalizeSpawn$lambda$1(TheBrokenEndEntity this$0) {
        this$0.discard();
    }

    private static final Unit baseTick$lambda$2(Level $level, BlockPos it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (((ServerLevel)$level).getBlockState(it).is(Blocks.WATER)) {
            ((ServerLevel)$level).setBlock(it, Blocks.COBBLESTONE.defaultBlockState(), 3);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Ldev/wendigodrip/thebrokenscript/entity/tbe/TheBrokenEndEntity$Companion;", "", "<init>", "()V", "createAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "thebrokenscript"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createAttributes() {
            AttributeSupplier.Builder builder = Monster.createMobAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"createMobAttributes(...)");
            return AttributesExt.INSTANCE.stepHeight(AttributesExt.INSTANCE.attackKnockback(AttributesExt.INSTANCE.knockbackResistance(AttributesExt.INSTANCE.followRange(AttributesExt.INSTANCE.attackDamage(AttributesExt.INSTANCE.armor(AttributesExt.INSTANCE.maxHealth(AttributesExt.INSTANCE.movementSpeed(builder, 0.45), 1000), 50), 600), 2016), 60), 50), 13);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

