/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.entity.siluet;

import dev.wendigodrip.thebrokenscript.TheBrokenScript;
import dev.wendigodrip.thebrokenscript.api.entity.FinalizedSpawn;
import dev.wendigodrip.thebrokenscript.api.entity.base.BaseMonster;
import dev.wendigodrip.thebrokenscript.api.entity.base.BaseSiluetEntity;
import dev.wendigodrip.thebrokenscript.api.ext.AttributesExt;
import dev.wendigodrip.thebrokenscript.api.ext.EntityFinder;
import dev.wendigodrip.thebrokenscript.api.ext.LevelExt;
import dev.wendigodrip.thebrokenscript.api.ext.PlayerExt;
import dev.wendigodrip.thebrokenscript.api.util.BlockBreakHelper;
import dev.wendigodrip.thebrokenscript.api.world.TimeOfDay;
import dev.wendigodrip.thebrokenscript.registry.TBSPackets;
import dev.wendigodrip.thebrokenscript.registry.TBSSounds;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J4\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\nH\u0016J\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u001fH\u0016\u00a8\u0006!"}, d2={"Ldev/wendigodrip/thebrokenscript/entity/siluet/SiluetChaseEntity;", "Ldev/wendigodrip/thebrokenscript/api/entity/base/BaseSiluetEntity;", "Ldev/wendigodrip/thebrokenscript/api/entity/FinalizedSpawn;", "type", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "registerGoals", "", "onFinalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnType", "Lnet/minecraft/world/entity/MobSpawnType;", "spawnData", "event", "Lnet/neoforged/neoforge/event/entity/living/FinalizeSpawnEvent;", "awardKillScore", "entity", "Lnet/minecraft/world/entity/Entity;", "score", "", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "baseTick", "movementPredicate", "Lsoftware/bernie/geckolib/animation/PlayState;", "Lsoftware/bernie/geckolib/animation/AnimationState;", "Companion", "thebrokenscript"})
public final class SiluetChaseEntity
extends BaseSiluetEntity
implements FinalizedSpawn {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public SiluetChaseEntity(@NotNull EntityType<SiluetChaseEntity> type, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super((EntityType<? extends BaseSiluetEntity>)type, level);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new FloatGoal((Mob)this));
    }

    @Override
    @Nullable
    public SpawnGroupData onFinalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @NotNull FinalizeSpawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnType, (String)"spawnType");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LevelAccessor levelAccessor = (LevelAccessor)level;
        Vec3 vec3 = this.getPos();
        Number number = 50;
        Object object = TBSSounds.NULL_CHASE.value();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"value(...)");
        LevelExt.tryBroadcastSoundInRange$default(LevelExt.INSTANCE, levelAccessor, vec3, number, (SoundEvent)object, 555.0f, 1.0f, null, 32, null);
        TheBrokenScript.INSTANCE.queueServerWork$thebrokenscript(800, () -> SiluetChaseEntity.onFinalizeSpawn$lambda$0(this));
        return null;
    }

    public void awardKillScore(@NotNull Entity entity, int score, @NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        super.awardKillScore(entity, score, source);
        if (this.level().isClientSide) {
            return;
        }
        this.discard();
        if (entity instanceof ServerPlayer) {
            PlayerExt.INSTANCE.trySendCustomPacket((Player)entity, (CustomPacketPayload)TBSPackets.FORCE_CRASH.create());
        }
    }

    public void baseTick() {
        super.baseTick();
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        BaseMonster.enableWaterWalking$default(this, null, 1, null);
        ServerPlayer player = EntityFinder.INSTANCE.findClosestPlayerInRange((ServerLevel)level, this.getPos(), (Number)800.0);
        if (player != null) {
            this.lookAt(EntityAnchorArgument.Anchor.EYES, player.position());
            this.setTarget((LivingEntity)player);
        }
        if ((double)this.random.nextFloat() < 0.01) {
            TimeOfDay.MIDNIGHT.setFake();
        } else if ((double)this.random.nextFloat() < 0.01) {
            TimeOfDay.DAY.setFake();
        }
        if (player != null && (player.isSpectator() || player.isCreative())) {
            player.setGameMode(GameType.SURVIVAL);
        }
        LevelAccessor levelAccessor = (LevelAccessor)level;
        BlockPos blockPos = BlockPos.containing((double)(this.getX() + 1.0), (double)this.getY(), (double)this.getZ());
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"containing(...)");
        BlockBreakHelper.INSTANCE.tryBreakCircuit(levelAccessor, blockPos);
        LevelAccessor levelAccessor2 = (LevelAccessor)level;
        BlockPos blockPos2 = BlockPos.containing((double)(this.getX() - 1.0), (double)this.getY(), (double)this.getZ());
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"containing(...)");
        BlockBreakHelper.INSTANCE.tryBreakCircuit(levelAccessor2, blockPos2);
        LevelAccessor levelAccessor3 = (LevelAccessor)level;
        BlockPos blockPos3 = BlockPos.containing((double)this.getX(), (double)this.getY(), (double)(this.getZ() + 1.0));
        Intrinsics.checkNotNullExpressionValue((Object)blockPos3, (String)"containing(...)");
        BlockBreakHelper.INSTANCE.tryBreakCircuit(levelAccessor3, blockPos3);
        LevelAccessor levelAccessor4 = (LevelAccessor)level;
        BlockPos blockPos4 = BlockPos.containing((double)this.getX(), (double)this.getY(), (double)(this.getZ() - 1.0));
        Intrinsics.checkNotNullExpressionValue((Object)blockPos4, (String)"containing(...)");
        BlockBreakHelper.INSTANCE.tryBreakCircuit(levelAccessor4, blockPos4);
        LevelAccessor levelAccessor5 = (LevelAccessor)level;
        BlockPos blockPos5 = BlockPos.containing((double)(this.getX() + 1.0), (double)(this.getY() + 1.0), (double)this.getZ());
        Intrinsics.checkNotNullExpressionValue((Object)blockPos5, (String)"containing(...)");
        BlockBreakHelper.INSTANCE.tryBreakCircuit(levelAccessor5, blockPos5);
        LevelAccessor levelAccessor6 = (LevelAccessor)level;
        BlockPos blockPos6 = BlockPos.containing((double)(this.getX() - 1.0), (double)(this.getY() + 1.0), (double)this.getZ());
        Intrinsics.checkNotNullExpressionValue((Object)blockPos6, (String)"containing(...)");
        BlockBreakHelper.INSTANCE.tryBreakCircuit(levelAccessor6, blockPos6);
        LevelAccessor levelAccessor7 = (LevelAccessor)level;
        BlockPos blockPos7 = BlockPos.containing((double)this.getX(), (double)(this.getY() + 1.0), (double)(this.getZ() + 1.0));
        Intrinsics.checkNotNullExpressionValue((Object)blockPos7, (String)"containing(...)");
        BlockBreakHelper.INSTANCE.tryBreakCircuit(levelAccessor7, blockPos7);
        LevelAccessor levelAccessor8 = (LevelAccessor)level;
        BlockPos blockPos8 = BlockPos.containing((double)this.getX(), (double)(this.getY() + 1.0), (double)(this.getZ() - 1.0));
        Intrinsics.checkNotNullExpressionValue((Object)blockPos8, (String)"containing(...)");
        BlockBreakHelper.INSTANCE.tryBreakCircuit(levelAccessor8, blockPos8);
        this.refreshDimensions();
    }

    @Override
    @Nullable
    public PlayState movementPredicate(@NotNull AnimationState<?> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        if (Intrinsics.areEqual((Object)this.getAnimProcedure(), (Object)"empty")) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.STOP;
    }

    @Override
    public void callFinalizeSpawn(@NotNull FinalizeSpawnEvent event) {
        FinalizedSpawn.DefaultImpls.callFinalizeSpawn(this, event);
    }

    private static final void onFinalizeSpawn$lambda$0(SiluetChaseEntity this$0) {
        this$0.discard();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Ldev/wendigodrip/thebrokenscript/entity/siluet/SiluetChaseEntity$Companion;", "", "<init>", "()V", "createAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "thebrokenscript"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createAttributes() {
            AttributeSupplier.Builder builder = Monster.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.4).add(Attributes.MAX_HEALTH, 10.0).add(Attributes.ARMOR, 0.0).add(Attributes.ATTACK_DAMAGE, 13.0).add(Attributes.FOLLOW_RANGE, 316.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return AttributesExt.INSTANCE.stepHeight(builder, 10.6);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

