/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.entity.nullent;

import dev.wendigodrip.thebrokenscript.TheBrokenScript;
import dev.wendigodrip.thebrokenscript.api.entity.FinalizedSpawn;
import dev.wendigodrip.thebrokenscript.api.entity.base.BaseMonster;
import dev.wendigodrip.thebrokenscript.api.ext.AttributesExt;
import dev.wendigodrip.thebrokenscript.api.ext.EntityExt;
import dev.wendigodrip.thebrokenscript.api.ext.EntityFinder;
import dev.wendigodrip.thebrokenscript.api.ext.EntityTypeExt;
import dev.wendigodrip.thebrokenscript.api.ext.LevelExt;
import dev.wendigodrip.thebrokenscript.api.ext.PlayerExt;
import dev.wendigodrip.thebrokenscript.api.util.BlockBreakHelper;
import dev.wendigodrip.thebrokenscript.api.world.TimeOfDay;
import dev.wendigodrip.thebrokenscript.config.TBSConfigs;
import dev.wendigodrip.thebrokenscript.registry.TBSEntities;
import dev.wendigodrip.thebrokenscript.registry.TBSLang;
import dev.wendigodrip.thebrokenscript.registry.TBSParticleTypes;
import dev.wendigodrip.thebrokenscript.registry.TBSSounds;
import dev.wendigodrip.thebrokenscript.vars.PlayerVariables;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0001(B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\fH\u0016J4\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0005\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J \u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0011H\u0016J\b\u0010%\u001a\u00020\nH\u0016J\u0010\u0010&\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020'H\u0016\u00a8\u0006)"}, d2={"Ldev/wendigodrip/thebrokenscript/entity/nullent/NullChaseEntity;", "Ldev/wendigodrip/thebrokenscript/api/entity/base/BaseMonster;", "Ldev/wendigodrip/thebrokenscript/api/entity/FinalizedSpawn;", "type", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "registerGoals", "", "removeWhenFarAway", "", "distanceToClosestPlayer", "", "hurt", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "amount", "", "fireImmune", "onFinalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnType", "Lnet/minecraft/world/entity/MobSpawnType;", "spawnData", "event", "Lnet/neoforged/neoforge/event/entity/living/FinalizeSpawnEvent;", "awardKillScore", "entity", "Lnet/minecraft/world/entity/Entity;", "score", "", "damageSource", "baseTick", "isPushedByFluid", "Lnet/neoforged/neoforge/fluids/FluidType;", "Companion", "thebrokenscript"})
public final class NullChaseEntity
extends BaseMonster
implements FinalizedSpawn {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public NullChaseEntity(@NotNull EntityType<NullChaseEntity> type, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(type, level);
        this.xpReward = 50;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return Intrinsics.areEqual((Object)source.type(), (Object)DamageTypes.GENERIC_KILL) || Intrinsics.areEqual((Object)source.type(), (Object)DamageTypes.FELL_OUT_OF_WORLD);
    }

    public boolean fireImmune() {
        return true;
    }

    @Override
    @Nullable
    public SpawnGroupData onFinalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @NotNull FinalizeSpawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnType, (String)"spawnType");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LevelExt.playSound$default(LevelExt.INSTANCE, (LevelAccessor)level, this.getPos(), (Holder)TBSSounds.NULL_JUMPSCARE_LOUD, 555.0f, 0.0f, null, 24, null);
        LevelExt.playSound$default(LevelExt.INSTANCE, (LevelAccessor)level, this.getPos(), (Holder)TBSSounds.NULL_CHASE, 555.0f, 0.0f, null, 24, null);
        TheBrokenScript.INSTANCE.queueServerWork$thebrokenscript(450, () -> NullChaseEntity.onFinalizeSpawn$lambda$0(level, this));
        for (ServerPlayer player : EntityFinder.INSTANCE.findPlayersInRange(level, this.getPos(), (Number)200)) {
            PlayerVariables vars = PlayerExt.INSTANCE.getVars((Player)player);
            vars.setEntityReputation(vars.getEntityReputation() - 1);
            vars.syncTo((Player)player);
        }
        return null;
    }

    public void awardKillScore(@NotNull Entity entity, int score, @NotNull DamageSource damageSource) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
            super.awardKillScore(entity, score, damageSource);
            Level level = this.level();
            if (!(level instanceof ServerLevel)) {
                return;
            }
            LevelExt.INSTANCE.tryBroadcastPacket((LevelAccessor)level, (Packet)new ClientboundStopSoundPacket(null, null));
            EntityExt.INSTANCE.discardNearest(NullChaseEntity.class, this.getPos(), level, 40);
            LevelAccessor levelAccessor = (LevelAccessor)level;
            Vec3 vec3 = this.getPos();
            Object object = TBSSounds.NULL_KILLS_PLAYER.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            LevelExt.playSound$default(LevelExt.INSTANCE, levelAccessor, vec3, (SoundEvent)object, 555.0f, 0.0f, null, 24, null);
            ServerPlayer serverPlayer = EntityFinder.INSTANCE.findClosestPlayerInRange((ServerLevel)level, this.getPos(), (Number)200.0);
            if (serverPlayer == null || (serverPlayer = serverPlayer.connection) == null) break block1;
            serverPlayer.disconnect((Component)TBSLang.INSTANCE.getNULL_CHASE_KICK());
        }
    }

    public void baseTick() {
        super.baseTick();
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        Block block = Blocks.MOSSY_COBBLESTONE;
        Intrinsics.checkNotNullExpressionValue((Object)block, (String)"MOSSY_COBBLESTONE");
        this.enableWaterWalking(block);
        ((ServerLevel)level).sendParticles((ParticleOptions)TBSParticleTypes.NULL_PARTICLE.get(), this.getX(), this.getY(), this.getZ(), 2, 2.0, 3.0, 2.0, 0.0);
        ServerPlayer serverPlayer = EntityFinder.INSTANCE.findClosestPlayerInRange((ServerLevel)level, this.getPos(), (Number)520.0);
        if (serverPlayer == null) {
            this.discard();
            return;
        }
        ServerPlayer player = serverPlayer;
        if (EntityExt.INSTANCE.isWithin((Entity)player, this.getPos(), 200.0)) {
            player.hurt(((ServerLevel)level).damageSources().fellOutOfWorld(), 0.2f);
            player.lookAt(EntityAnchorArgument.Anchor.EYES, this.getPos());
        }
        this.setTarget((LivingEntity)player);
        if ((double)this.random.nextFloat() < 0.01) {
            TimeOfDay.MIDNIGHT.setFake();
        } else if ((double)this.random.nextFloat() < 0.01) {
            TimeOfDay.DAY.setFake();
        }
        BlockPos pos = BlockPos.containing((double)this.getX(), (double)this.getY(), (double)this.getZ());
        if (!TBSConfigs.COMMON.getDisableBlockBreaking()) {
            LevelAccessor levelAccessor = (LevelAccessor)level;
            BlockPos blockPos = pos.offset(1, 0, 0);
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"offset(...)");
            BlockBreakHelper.INSTANCE.tryBreakNull(levelAccessor, blockPos);
            LevelAccessor levelAccessor2 = (LevelAccessor)level;
            BlockPos blockPos2 = pos.offset(-1, 0, 0);
            Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"offset(...)");
            BlockBreakHelper.INSTANCE.tryBreakNull(levelAccessor2, blockPos2);
            LevelAccessor levelAccessor3 = (LevelAccessor)level;
            BlockPos blockPos3 = pos.offset(0, 0, 1);
            Intrinsics.checkNotNullExpressionValue((Object)blockPos3, (String)"offset(...)");
            BlockBreakHelper.INSTANCE.tryBreakNull(levelAccessor3, blockPos3);
            LevelAccessor levelAccessor4 = (LevelAccessor)level;
            BlockPos blockPos4 = pos.offset(0, 0, -1);
            Intrinsics.checkNotNullExpressionValue((Object)blockPos4, (String)"offset(...)");
            BlockBreakHelper.INSTANCE.tryBreakNull(levelAccessor4, blockPos4);
            LevelAccessor levelAccessor5 = (LevelAccessor)level;
            BlockPos blockPos5 = pos.offset(1, 1, 0);
            Intrinsics.checkNotNullExpressionValue((Object)blockPos5, (String)"offset(...)");
            BlockBreakHelper.INSTANCE.tryBreakNull(levelAccessor5, blockPos5);
            LevelAccessor levelAccessor6 = (LevelAccessor)level;
            BlockPos blockPos6 = pos.offset(-1, 1, 0);
            Intrinsics.checkNotNullExpressionValue((Object)blockPos6, (String)"offset(...)");
            BlockBreakHelper.INSTANCE.tryBreakNull(levelAccessor6, blockPos6);
            LevelAccessor levelAccessor7 = (LevelAccessor)level;
            BlockPos blockPos7 = pos.offset(0, 1, 1);
            Intrinsics.checkNotNullExpressionValue((Object)blockPos7, (String)"offset(...)");
            BlockBreakHelper.INSTANCE.tryBreakNull(levelAccessor7, blockPos7);
            LevelAccessor levelAccessor8 = (LevelAccessor)level;
            BlockPos blockPos8 = pos.offset(0, 1, -1);
            Intrinsics.checkNotNullExpressionValue((Object)blockPos8, (String)"offset(...)");
            BlockBreakHelper.INSTANCE.tryBreakNull(levelAccessor8, blockPos8);
        }
        if (((ServerLevel)level).getBlockState(pos.offset(0, -1, 0)).is(Blocks.WATER) || ((ServerLevel)level).getBlockState(pos).is(Blocks.WATER)) {
            BlockHitResult rayCast = ((ServerLevel)level).clip(new ClipContext(this.getEyePosition(1.0f), this.getEyePosition(1.0f).add(this.getViewVector(1.0f).scale(0.1)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this));
            this.teleportTo(rayCast.getBlockPos().getCenter().x, rayCast.getBlockPos().getCenter().y, rayCast.getBlockPos().getCenter().z);
            BlockHitResult rayCast2 = ((ServerLevel)level).clip(new ClipContext(this.getEyePosition(1.0f), this.getEyePosition(1.0f).add(this.getViewVector(1.0f).scale(0.1)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this));
            this.teleportTo(rayCast2.getBlockPos().getCenter().x, rayCast2.getBlockPos().getCenter().y, rayCast2.getBlockPos().getCenter().z);
        }
        if (!TBSConfigs.COMMON.getDisableBlockBreaking() && this.random.nextBoolean()) {
            int mult = this.random.nextBoolean() ? 1 : -1;
            BlockPos newPos = pos.offset(this.random.nextInt(0, 2) * mult, this.random.nextInt(0, 3) * mult, this.random.nextInt(0, 2) * mult);
            ((ServerLevel)level).setBlock(newPos, Blocks.AIR.defaultBlockState(), 3);
        }
        player.setGameMode(GameType.SURVIVAL);
    }

    public boolean isPushedByFluid(@NotNull FluidType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return false;
    }

    @Override
    public void callFinalizeSpawn(@NotNull FinalizeSpawnEvent event) {
        FinalizedSpawn.DefaultImpls.callFinalizeSpawn(this, event);
    }

    private static final void onFinalizeSpawn$lambda$0(ServerLevelAccessor $level, NullChaseEntity this$0) {
        LevelExt.INSTANCE.tryBroadcastPacket((LevelAccessor)$level, (Packet)new ClientboundStopSoundPacket(null, null));
        this$0.discard();
        if ((double)this$0.random.nextFloat() < 0.7) {
            Object object = TBSEntities.getNULL_IS_HERE().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            EntityExt.INSTANCE.applyRandomRotation(EntityTypeExt.INSTANCE.trySummon((EntityType)object, (LevelAccessor)$level, this$0.getPos()));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Ldev/wendigodrip/thebrokenscript/entity/nullent/NullChaseEntity$Companion;", "", "<init>", "()V", "createAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "thebrokenscript"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createAttributes() {
            AttributeSupplier.Builder builder = Monster.createMobAttributes();
            builder = builder.add(Attributes.MOVEMENT_SPEED, 0.3);
            builder = builder.add(Attributes.MAX_HEALTH, 510.0);
            builder = builder.add(Attributes.ARMOR, 0.0);
            builder = builder.add(Attributes.ATTACK_DAMAGE, 513.0);
            AttributeSupplier.Builder builder2 = builder.add(Attributes.FOLLOW_RANGE, 416.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"add(...)");
            builder = AttributesExt.INSTANCE.stepHeight(builder2, 10.6);
            return builder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

