/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.entity.misc;

import dev.wendigodrip.thebrokenscript.api.entity.FinalizedSpawn;
import dev.wendigodrip.thebrokenscript.api.entity.base.BaseMonster;
import dev.wendigodrip.thebrokenscript.api.ext.BlockExt;
import dev.wendigodrip.thebrokenscript.api.ext.BlockPosExt;
import dev.wendigodrip.thebrokenscript.config.TBSConfigs;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ4\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Ldev/wendigodrip/thebrokenscript/entity/misc/CorruptionEntity;", "Ldev/wendigodrip/thebrokenscript/api/entity/base/BaseMonster;", "Ldev/wendigodrip/thebrokenscript/api/entity/FinalizedSpawn;", "type", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "onFinalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnType", "Lnet/minecraft/world/entity/MobSpawnType;", "spawnData", "event", "Lnet/neoforged/neoforge/event/entity/living/FinalizeSpawnEvent;", "thebrokenscript"})
public final class CorruptionEntity
extends BaseMonster
implements FinalizedSpawn {
    public CorruptionEntity(@NotNull EntityType<CorruptionEntity> type, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(type, level);
    }

    @Override
    @Nullable
    public SpawnGroupData onFinalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @NotNull FinalizeSpawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnType, (String)"spawnType");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.getOnSurface() && TBSConfigs.COMMON.getWorld().getEnableVoidHoles() && (double)this.random.nextFloat() <= 0.7) {
            int n;
            int dig = level.getMinBuildHeight();
            if (dig <= (n = (int)this.getY())) {
                while (true) {
                    BlockPos blockPos = BlockPosExt.INSTANCE.withY(this.getBlockPos(), dig);
                    Block block = Blocks.AIR;
                    Intrinsics.checkNotNullExpressionValue((Object)block, (String)"AIR");
                    level.setBlock(blockPos, BlockExt.INSTANCE.default(block), 3);
                    if (dig == n) break;
                    ++dig;
                }
            }
            BlockPos blockPos = this.getBlockPos().offset(1, 0, 0);
            Block block = Blocks.REDSTONE_TORCH;
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"REDSTONE_TORCH");
            level.setBlock(blockPos, BlockExt.INSTANCE.default(block), 3);
            BlockPos blockPos2 = this.getBlockPos().offset(-1, 0, 0);
            Block block2 = Blocks.REDSTONE_TORCH;
            Intrinsics.checkNotNullExpressionValue((Object)block2, (String)"REDSTONE_TORCH");
            level.setBlock(blockPos2, BlockExt.INSTANCE.default(block2), 3);
            BlockPos blockPos3 = this.getBlockPos().offset(0, 0, 1);
            Block block3 = Blocks.REDSTONE_TORCH;
            Intrinsics.checkNotNullExpressionValue((Object)block3, (String)"REDSTONE_TORCH");
            level.setBlock(blockPos3, BlockExt.INSTANCE.default(block3), 3);
            BlockPos blockPos4 = this.getBlockPos().offset(0, 0, -1);
            Block block4 = Blocks.REDSTONE_TORCH;
            Intrinsics.checkNotNullExpressionValue((Object)block4, (String)"REDSTONE_TORCH");
            level.setBlock(blockPos4, BlockExt.INSTANCE.default(block4), 3);
        }
        event.setSpawnCancelled(true);
        return null;
    }

    @Override
    public void callFinalizeSpawn(@NotNull FinalizeSpawnEvent event) {
        FinalizedSpawn.DefaultImpls.callFinalizeSpawn(this, event);
    }
}

