/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.entity.circuit;

import dev.wendigodrip.thebrokenscript.TheBrokenScript;
import dev.wendigodrip.thebrokenscript.api.entity.FinalizedSpawn;
import dev.wendigodrip.thebrokenscript.api.ext.EntityExt;
import dev.wendigodrip.thebrokenscript.api.ext.EntityFinder;
import dev.wendigodrip.thebrokenscript.api.ext.EntityTypeExt;
import dev.wendigodrip.thebrokenscript.entity.circuit.PigCircuitEntity;
import dev.wendigodrip.thebrokenscript.registry.TBSEntities;
import dev.wendigodrip.thebrokenscript.registry.TBSLang;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u00012\u00020\u0002:\u0001\u001dB\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J4\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0005\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\nH\u0016\u00a8\u0006\u001e"}, d2={"Ldev/wendigodrip/thebrokenscript/entity/circuit/FalseVillagerEntity;", "Lnet/minecraft/world/entity/monster/Monster;", "Ldev/wendigodrip/thebrokenscript/api/entity/FinalizedSpawn;", "type", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "registerGoals", "", "removeWhenFarAway", "", "distanceToClosestPlayer", "", "die", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "onFinalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnType", "Lnet/minecraft/world/entity/MobSpawnType;", "spawnData", "event", "Lnet/neoforged/neoforge/event/entity/living/FinalizeSpawnEvent;", "baseTick", "Companion", "thebrokenscript"})
public final class FalseVillagerEntity
extends Monster
implements FinalizedSpawn {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public FalseVillagerEntity(@NotNull EntityType<FalseVillagerEntity> type, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(type, level);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setCustomName((Component)TBSLang.INSTANCE.getFALSE_VILLAGER_NAME());
        this.setCustomNameVisible(true);
        this.setPersistenceRequired();
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.goalSelector.addGoal(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public void die(@NotNull DamageSource source) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            super.die(source);
            Object object = TBSEntities.getCIRCUIT().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            EntityType entityType = (EntityType)object;
            Level level = this.level();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
            LevelAccessor levelAccessor = (LevelAccessor)level;
            Vec3 vec3 = this.position();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
            Entity entity = EntityTypeExt.INSTANCE.trySummon(entityType, levelAccessor, vec3);
            if (entity == null) break block0;
            EntityExt.INSTANCE.applyRandomRotation(entity);
        }
    }

    @Override
    @Nullable
    public SpawnGroupData onFinalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @NotNull FinalizeSpawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnType, (String)"spawnType");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 100, 1, false, false));
        LevelAccessor levelAccessor = (LevelAccessor)level;
        Vec3 vec3 = this.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        Class[] classArray = new Class[]{FalseVillagerEntity.class, PigCircuitEntity.class};
        if ((double)EntityFinder.INSTANCE.findEntitiesInRange(levelAccessor, vec3, 500.0, classArray).size() >= 2.0) {
            event.setSpawnCancelled(true);
        } else {
            TheBrokenScript.INSTANCE.queueServerWork$thebrokenscript(18000, () -> FalseVillagerEntity.onFinalizeSpawn$lambda$0(this));
        }
        return null;
    }

    public void baseTick() {
        super.baseTick();
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        Player player = EntityFinder.INSTANCE.findClosestEntityInRange((LevelAccessor)level, Player.class, new Vec3(this.getX(), this.getY(), this.getZ()), 1000.0);
        if (player != null && player.position().distanceToSqr(this.getX(), this.getY(), this.getZ()) <= Mth.square((double)20.0)) {
            if (this.random.nextDouble() < 1.0E-4) {
                this.discard();
                Object object = TBSEntities.getCIRCUIT().get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                EntityType entityType = (EntityType)object;
                LevelAccessor levelAccessor = (LevelAccessor)level;
                Vec3 vec3 = this.position();
                Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
                Entity entity = EntityTypeExt.INSTANCE.trySummon(entityType, levelAccessor, vec3);
                if (entity != null) {
                    EntityExt.INSTANCE.applyRandomRotation(entity);
                }
            } else {
                this.setTarget(null);
            }
        } else if (player != null) {
            this.setTarget((LivingEntity)player);
            IronGolem ironGolem = EntityFinder.INSTANCE.findClosestEntityInRange((LevelAccessor)level, IronGolem.class, new Vec3(this.getX(), this.getY(), this.getZ()), 50.0);
            if (ironGolem != null) {
                ironGolem.setTarget((LivingEntity)player);
            }
        }
        if (((ServerLevel)level).isDay() && this.random.nextDouble() < 1.0E-4) {
            this.discard();
        }
    }

    @Override
    public void callFinalizeSpawn(@NotNull FinalizeSpawnEvent event) {
        FinalizedSpawn.DefaultImpls.callFinalizeSpawn(this, event);
    }

    private static final void onFinalizeSpawn$lambda$0(FalseVillagerEntity this$0) {
        this$0.discard();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Ldev/wendigodrip/thebrokenscript/entity/circuit/FalseVillagerEntity$Companion;", "", "<init>", "()V", "createAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "thebrokenscript"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createAttributes() {
            AttributeSupplier.Builder builder = Monster.createMobAttributes();
            builder = builder.add(Attributes.MOVEMENT_SPEED, 0.25);
            builder = builder.add(Attributes.MAX_HEALTH, 10.0);
            builder = builder.add(Attributes.ARMOR, 0.0);
            builder = builder.add(Attributes.ATTACK_DAMAGE, 3.0);
            AttributeSupplier.Builder builder2 = builder = builder.add(Attributes.FOLLOW_RANGE, 916.0);
            Intrinsics.checkNotNull((Object)builder2);
            return builder2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

