/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.entity.circuit;

import dev.wendigodrip.thebrokenscript.api.entity.FinalizedSpawn;
import dev.wendigodrip.thebrokenscript.api.entity.base.BaseCircuitEntity;
import dev.wendigodrip.thebrokenscript.api.ext.LevelExt;
import dev.wendigodrip.thebrokenscript.behaviors.CircuitStalkBehavior;
import dev.wendigodrip.thebrokenscript.entity.circuit.CircuitUtil;
import dev.wendigodrip.thebrokenscript.registry.TBSBiomes;
import dev.wendigodrip.thebrokenscript.registry.TBSSounds;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u001f\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ4\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u001bH\u0016\u00a8\u0006\u001c"}, d2={"Ldev/wendigodrip/thebrokenscript/entity/circuit/CircuitStalkEntity;", "Ldev/wendigodrip/thebrokenscript/api/entity/base/BaseCircuitEntity;", "Ldev/wendigodrip/thebrokenscript/api/entity/FinalizedSpawn;", "type", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "onFinalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnType", "Lnet/minecraft/world/entity/MobSpawnType;", "spawnData", "event", "Lnet/neoforged/neoforge/event/entity/living/FinalizeSpawnEvent;", "baseTick", "", "getDefaultDimensions", "Lnet/minecraft/world/entity/EntityDimensions;", "pose", "Lnet/minecraft/world/entity/Pose;", "movementPredicate", "Lsoftware/bernie/geckolib/animation/PlayState;", "Lsoftware/bernie/geckolib/animation/AnimationState;", "thebrokenscript"})
public class CircuitStalkEntity
extends BaseCircuitEntity
implements FinalizedSpawn {
    public CircuitStalkEntity(@NotNull EntityType<? extends CircuitStalkEntity> type, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(type, level);
    }

    @Override
    @Nullable
    public SpawnGroupData onFinalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @NotNull FinalizeSpawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnType, (String)"spawnType");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!(level instanceof ServerLevel)) {
            return null;
        }
        Object[] objectArray = new ResourceKey[]{TBSBiomes.NULL_BIOME, Biomes.DEEP_DARK};
        if (CircuitUtil.INSTANCE.isIllegalSpawnForCircuit(this, CollectionsKt.listOf((Object[])objectArray)) || (double)this.random.nextFloat() >= 0.01) {
            event.setSpawnCancelled(true);
            return null;
        }
        LevelExt.playSound$default(LevelExt.INSTANCE, (LevelAccessor)level, this.getPos(), (Holder)((double)this.random.nextFloat() < 0.7 ? TBSSounds.FALSE_CALM_2 : TBSSounds.INTEGRITY_WATCHING), 555.0f, 0.0f, null, 24, null);
        CircuitUtil.INSTANCE.onceSpawned(this);
        return null;
    }

    public void baseTick() {
        this.onServerTick((Function1<? super ServerLevel, Unit>)((Function1)arg_0 -> CircuitStalkEntity.baseTick$lambda$0(this, arg_0)));
    }

    @NotNull
    protected EntityDimensions getDefaultDimensions(@NotNull Pose pose) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        EntityDimensions entityDimensions = super.getDefaultDimensions(pose).scale(1.0f);
        Intrinsics.checkNotNullExpressionValue((Object)entityDimensions, (String)"scale(...)");
        return entityDimensions;
    }

    @Override
    @Nullable
    public PlayState movementPredicate(@NotNull AnimationState<?> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        if (Intrinsics.areEqual((Object)this.getAnimProcedure(), (Object)"empty")) {
            if (event.isMoving() || !(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("chase"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("idle"));
        }
        return PlayState.STOP;
    }

    @Override
    public void callFinalizeSpawn(@NotNull FinalizeSpawnEvent event) {
        FinalizedSpawn.DefaultImpls.callFinalizeSpawn(this, event);
    }

    private static final Unit baseTick$lambda$0(CircuitStalkEntity this$0, ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        CircuitStalkBehavior.INSTANCE.tick(level, this$0.getPos(), this$0);
        this$0.refreshDimensions();
        return Unit.INSTANCE;
    }
}

