/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.entity.circuit;

import dev.wendigodrip.thebrokenscript.api.entity.FinalizedSpawn;
import dev.wendigodrip.thebrokenscript.api.entity.base.BaseCircuitEntity;
import dev.wendigodrip.thebrokenscript.api.ext.AttributesExt;
import dev.wendigodrip.thebrokenscript.api.ext.BoundingBoxExt;
import dev.wendigodrip.thebrokenscript.api.ext.LevelExt;
import dev.wendigodrip.thebrokenscript.behaviors.CircuitStalkBehavior;
import dev.wendigodrip.thebrokenscript.entity.circuit.CircuitUtil;
import dev.wendigodrip.thebrokenscript.vars.MapVariables;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u001f\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ4\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Ldev/wendigodrip/thebrokenscript/entity/circuit/CircuitMineshaftWalkEntity;", "Ldev/wendigodrip/thebrokenscript/api/entity/base/BaseCircuitEntity;", "Ldev/wendigodrip/thebrokenscript/api/entity/FinalizedSpawn;", "type", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "onFinalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnType", "Lnet/minecraft/world/entity/MobSpawnType;", "spawnData", "event", "Lnet/neoforged/neoforge/event/entity/living/FinalizeSpawnEvent;", "baseTick", "", "Companion", "thebrokenscript"})
public class CircuitMineshaftWalkEntity
extends BaseCircuitEntity
implements FinalizedSpawn {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public CircuitMineshaftWalkEntity(@NotNull EntityType<? extends CircuitMineshaftWalkEntity> type, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(type, level);
    }

    @Override
    @Nullable
    public SpawnGroupData onFinalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @NotNull FinalizeSpawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnType, (String)"spawnType");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (CircuitUtil.isIllegalSpawnForCircuit$default(CircuitUtil.INSTANCE, this, null, 1, null)) {
            event.setSpawnCancelled(true);
            return null;
        }
        BoundingBox boundingBox = new BoundingBox(this.getBlockPos()).inflatedBy(3);
        Intrinsics.checkNotNullExpressionValue((Object)boundingBox, (String)"inflatedBy(...)");
        for (BlockPos pos : BoundingBoxExt.INSTANCE.getPositions(boundingBox)) {
            if (!level.getBlockState(pos).is(Blocks.OAK_PLANKS)) continue;
            if ((double)this.random.nextFloat() < 0.1) {
                MapVariables vars = LevelExt.INSTANCE.getVars((LevelAccessor)level);
                LevelAccessor levelAccessor = (LevelAccessor)level;
                Vec3 vec3 = this.getPos();
                Holder.Reference reference = SoundEvents.AMBIENT_CAVE;
                Intrinsics.checkNotNullExpressionValue((Object)reference, (String)"AMBIENT_CAVE");
                LevelExt.playSound$default(LevelExt.INSTANCE, levelAccessor, vec3, (Holder)reference, 555.0f, 0.0f, null, 16, null);
                vars.setHasCircuitSpawned(true);
                vars.syncData((LevelAccessor)level);
                this.queueDiscard(10000);
                break;
            }
            event.setSpawnCancelled(true);
            break;
        }
        return null;
    }

    public void baseTick() {
        this.onServerTick((Function1<? super ServerLevel, Unit>)((Function1)arg_0 -> CircuitMineshaftWalkEntity.baseTick$lambda$0(this, arg_0)));
    }

    @Override
    public void callFinalizeSpawn(@NotNull FinalizeSpawnEvent event) {
        FinalizedSpawn.DefaultImpls.callFinalizeSpawn(this, event);
    }

    private static final Unit baseTick$lambda$0(CircuitMineshaftWalkEntity this$0, ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        CircuitStalkBehavior.INSTANCE.tick(level, this$0.getPos(), this$0);
        this$0.refreshDimensions();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Ldev/wendigodrip/thebrokenscript/entity/circuit/CircuitMineshaftWalkEntity$Companion;", "", "<init>", "()V", "createAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "thebrokenscript"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeSupplier.Builder createAttributes() {
            AttributeSupplier.Builder builder = Monster.createMobAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"createMobAttributes(...)");
            return AttributesExt.INSTANCE.stepHeight(AttributesExt.INSTANCE.followRange(AttributesExt.INSTANCE.attackDamage(AttributesExt.INSTANCE.armor(AttributesExt.INSTANCE.maxHealth(AttributesExt.INSTANCE.movementSpeed(builder, 0.3), 910), 0), 3), 916), 80.6);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

