/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.entity;

import dev.wendigodrip.thebrokenscript.TheBrokenScript;
import dev.wendigodrip.thebrokenscript.api.entity.FinalizedSpawn;
import dev.wendigodrip.thebrokenscript.api.entity.base.BaseMonster;
import dev.wendigodrip.thebrokenscript.api.ext.EntityFinder;
import dev.wendigodrip.thebrokenscript.api.ext.PosExt;
import dev.wendigodrip.thebrokenscript.registry.TBSTags;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0014J4\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\fH\u0016\u00a8\u0006\u0018"}, d2={"Ldev/wendigodrip/thebrokenscript/entity/StareEntity;", "Ldev/wendigodrip/thebrokenscript/api/entity/base/BaseMonster;", "Ldev/wendigodrip/thebrokenscript/api/entity/FinalizedSpawn;", "type", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "isPushable", "", "registerGoals", "", "onFinalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnType", "Lnet/minecraft/world/entity/MobSpawnType;", "spawnData", "event", "Lnet/neoforged/neoforge/event/entity/living/FinalizeSpawnEvent;", "baseTick", "thebrokenscript"})
public final class StareEntity
extends BaseMonster
implements FinalizedSpawn {
    public StareEntity(@NotNull EntityType<StareEntity> type, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(type, level);
        AttributeInstance attributeInstance = this.getAttribute(Attributes.STEP_HEIGHT);
        Intrinsics.checkNotNull((Object)attributeInstance);
        attributeInstance.setBaseValue(0.6);
        this.xpReward = 0;
        this.setNoAi(false);
    }

    public boolean isPushable() {
        return false;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.goalSelector.addGoal(2, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(4, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(5, (Goal)new FloatGoal((Mob)this));
    }

    @Override
    @Nullable
    public SpawnGroupData onFinalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @NotNull FinalizeSpawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnType, (String)"spawnType");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        TheBrokenScript.INSTANCE.queueServerWork$thebrokenscript(3, () -> StareEntity.onFinalizeSpawn$lambda$0(this));
        return null;
    }

    public void baseTick() {
        this.onServerTick((Function1<? super ServerLevel, Unit>)((Function1)arg_0 -> StareEntity.baseTick$lambda$1(this, arg_0)));
    }

    @Override
    public void callFinalizeSpawn(@NotNull FinalizeSpawnEvent event) {
        FinalizedSpawn.DefaultImpls.callFinalizeSpawn(this, event);
    }

    private static final void onFinalizeSpawn$lambda$0(StareEntity this$0) {
        this$0.discard();
    }

    private static final Unit baseTick$lambda$1(StareEntity this$0, ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        ServerPlayer serverPlayer = EntityFinder.INSTANCE.findClosestPlayerInRange(level, this$0.getPos(), (Number)4100);
        if (serverPlayer == null) {
            return Unit.INSTANCE;
        }
        ServerPlayer player = serverPlayer;
        for (Entity entity : EntityFinder.INSTANCE.findSortedEntitiesInRange((LevelAccessor)level, Entity.class, this$0.getPos(), 1000)) {
            if (!entity.getType().is(TBSTags.LOOKABLE)) continue;
            Vec3 vec3 = player.position();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
            entity.lookAt(EntityAnchorArgument.Anchor.EYES, PosExt.above$default(PosExt.INSTANCE, vec3, null, 1, null));
            if (!(entity instanceof LivingEntity)) continue;
            ((LivingEntity)entity).addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 55, false, false));
        }
        return Unit.INSTANCE;
    }
}

