/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.entity;

import dev.wendigodrip.thebrokenscript.TheBrokenScript;
import dev.wendigodrip.thebrokenscript.api.entity.FinalizedSpawn;
import dev.wendigodrip.thebrokenscript.api.entity.base.UwuableMonster;
import dev.wendigodrip.thebrokenscript.api.ext.ComponentExt;
import dev.wendigodrip.thebrokenscript.api.ext.EntityFinder;
import dev.wendigodrip.thebrokenscript.api.ext.LevelExt;
import dev.wendigodrip.thebrokenscript.api.util.BlockBreakHelper;
import dev.wendigodrip.thebrokenscript.registry.TBSItems;
import dev.wendigodrip.thebrokenscript.registry.TBSLang;
import dev.wendigodrip.thebrokenscript.registry.TBSParticleTypes;
import dev.wendigodrip.thebrokenscript.registry.TBSSounds;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundStopSoundPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.entity.living.FinalizeSpawnEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 -2\u00020\u00012\u00020\u0002:\u0001-B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\nH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J4\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0005\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\n2\u0006\u0010 \u001a\u00020!H\u0016J \u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0014H\u0016J\b\u0010)\u001a\u00020\nH\u0016J\u0016\u0010*\u001a\u0004\u0018\u00010+2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030,H\u0016\u00a8\u0006."}, d2={"Ldev/wendigodrip/thebrokenscript/entity/CurvedEntity;", "Ldev/wendigodrip/thebrokenscript/api/entity/base/UwuableMonster;", "Ldev/wendigodrip/thebrokenscript/api/entity/FinalizedSpawn;", "type", "Lnet/minecraft/world/entity/EntityType;", "level", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "defineSynchedData", "", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "registerGoals", "removeWhenFarAway", "", "distanceToClosestPlayer", "", "die", "source", "Lnet/minecraft/world/damagesource/DamageSource;", "onFinalizeSpawn", "Lnet/minecraft/world/entity/SpawnGroupData;", "Lnet/minecraft/world/level/ServerLevelAccessor;", "difficulty", "Lnet/minecraft/world/DifficultyInstance;", "spawnType", "Lnet/minecraft/world/entity/MobSpawnType;", "spawnData", "event", "Lnet/neoforged/neoforge/event/entity/living/FinalizeSpawnEvent;", "addAdditionalSaveData", "compound", "Lnet/minecraft/nbt/CompoundTag;", "readAdditionalSaveData", "awardKillScore", "entity", "Lnet/minecraft/world/entity/Entity;", "score", "", "damageSource", "baseTick", "movementPredicate", "Lsoftware/bernie/geckolib/animation/PlayState;", "Lsoftware/bernie/geckolib/animation/AnimationState;", "Companion", "thebrokenscript"})
@SourceDebugExtension(value={"SMAP\nCurvedEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CurvedEntity.kt\ndev/wendigodrip/thebrokenscript/entity/CurvedEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,225:1\n1863#2,2:226\n*S KotlinDebug\n*F\n+ 1 CurvedEntity.kt\ndev/wendigodrip/thebrokenscript/entity/CurvedEntity\n*L\n100#1:226,2\n*E\n"})
public final class CurvedEntity
extends UwuableMonster
implements FinalizedSpawn {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final EntityDataAccessor<Integer> DESPAWN_TIMER;

    public CurvedEntity(@NotNull EntityType<CurvedEntity> type, @NotNull Level level) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        super(type, level);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setCustomName((Component)TBSLang.INSTANCE.getCURVED_NAME());
        this.setCustomNameVisible(true);
        this.setPersistenceRequired();
    }

    @Override
    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.defineSynchedData(builder);
        builder.define(DESPAWN_TIMER, (Object)0);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false));
        this.goalSelector.addGoal(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.targetSelector.addGoal(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(7, (Goal)new FloatGoal((Mob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public void die(@NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        super.die(source);
        LevelExt.INSTANCE.tryBroadcastPacket((LevelAccessor)this.getLevel(), (Packet)new ClientboundStopSoundPacket(null, null));
        Object[] objectArray = new ItemStack[]{new ItemStack((ItemLike)Blocks.COBBLESTONE, this.random.nextInt(1, 25)), new ItemStack((ItemLike)Items.IRON_INGOT, this.random.nextInt(1, 25)), new ItemStack((ItemLike)Items.STONE_AXE), new ItemStack((ItemLike)Items.STONE_SWORD), new ItemStack((ItemLike)TBSItems.RECORD_16.get()), new ItemStack((ItemLike)Items.DIRT), new ItemStack((ItemLike)Items.REDSTONE_TORCH), new ItemStack((ItemLike)Items.OAK_PLANKS), new ItemStack((ItemLike)Items.OAK_LOG), new ItemStack((ItemLike)Items.ROTTEN_FLESH), new ItemStack((ItemLike)Items.STRING), new ItemStack((ItemLike)Items.OAK_SAPLING), new ItemStack((ItemLike)Items.DIAMOND)};
        Iterable $this$forEach$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ItemStack it = (ItemStack)element$iv;
            boolean bl = false;
            LevelExt.tryDropItems$default(LevelExt.INSTANCE, (LevelAccessor)this.getLevel(), this.getPos(), it, 0, 4, null);
        }
        if (source.getEntity() != null) {
            LevelAccessor levelAccessor = (LevelAccessor)this.getLevel();
            String string = ComponentExt.INSTANCE.getTranslationKey((Component)TBSLang.INSTANCE.getCURVED_DEATH());
            Intrinsics.checkNotNull((Object)string);
            Object[] objectArray2 = new Object[1];
            Entity entity = source.getEntity();
            objectArray2[0] = entity != null ? entity.getDisplayName() : null;
            MutableComponent mutableComponent = Component.translatable((String)string, (Object[])objectArray2);
            Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translatable(...)");
            v4 = LevelExt.chat$default(LevelExt.INSTANCE, levelAccessor, (Component)mutableComponent, false, 2, null);
        } else {
            v4 = LevelExt.chat$default(LevelExt.INSTANCE, (LevelAccessor)this.getLevel(), (Component)TBSLang.INSTANCE.getCURVED_DEATH_UNKNOWN(), false, 2, null);
        }
        TheBrokenScript.INSTANCE.queueServerWork$thebrokenscript(100, () -> CurvedEntity.die$lambda$1(this));
    }

    @Override
    @Nullable
    public SpawnGroupData onFinalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnData, @NotNull FinalizeSpawnEvent event) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)difficulty, (String)"difficulty");
        Intrinsics.checkNotNullParameter((Object)spawnType, (String)"spawnType");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LevelAccessor levelAccessor = (LevelAccessor)level;
        Vec3 vec3 = this.getPos();
        Object object = TBSSounds.YOU_KNOW_NOTHING.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        LevelExt.playSound$default(LevelExt.INSTANCE, levelAccessor, vec3, (SoundEvent)object, 555.0f, 0.0f, null, 16, null);
        for (int yi = -2; yi < 3; ++yi) {
            for (int xi = -2; xi < 3; ++xi) {
                for (int zi = -2; zi < 3; ++zi) {
                    LevelAccessor levelAccessor2 = (LevelAccessor)this.getLevel();
                    BlockPos blockPos = this.getBlockPos().offset(xi, yi, zi);
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"offset(...)");
                    BlockBreakHelper.INSTANCE.tryBreakCircuit(levelAccessor2, blockPos);
                }
            }
        }
        return null;
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.addAdditionalSaveData(compound);
        Object object = this.entityData.get(DESPAWN_TIMER);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        compound.putInt("despawn_timer", ((Number)object).intValue());
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.readAdditionalSaveData(compound);
        if (compound.contains("despawn_timer")) {
            this.entityData.set(DESPAWN_TIMER, (Object)compound.getInt("despawn_timer"));
        }
    }

    public void awardKillScore(@NotNull Entity entity, int score, @NotNull DamageSource damageSource) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
            super.awardKillScore(entity, score, damageSource);
            Level level = this.level();
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
            CurvedEntity other = EntityFinder.INSTANCE.findClosestEntityInRange((LevelAccessor)level, CurvedEntity.class, new Vec3(this.getX(), this.getY(), this.getZ()), 40.0);
            if (this.level().isClientSide) break block1;
            CurvedEntity curvedEntity = other;
            if (curvedEntity != null) {
                curvedEntity.discard();
            }
        }
    }

    public void baseTick() {
        ServerPlayer serverPlayer;
        super.baseTick();
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            this.refreshDimensions();
            return;
        }
        LevelAccessor levelAccessor = (LevelAccessor)level;
        Vec3 vec3 = new Vec3(this.getX(), this.getY(), this.getZ());
        Object object = TBSSounds.CURVED_SPAWN.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        LevelExt.playSound$default(LevelExt.INSTANCE, levelAccessor, vec3, (SoundEvent)object, 555.0f, 0.0f, null, 16, null);
        Integer despawnTimer = (Integer)this.entityData.get(DESPAWN_TIMER);
        this.entityData.set(DESPAWN_TIMER, (Object)(despawnTimer + 1));
        for (int yi = -2; yi < 3; ++yi) {
            for (int xi = -2; xi < 3; ++xi) {
                for (int zi = -2; zi < 3; ++zi) {
                    LevelAccessor levelAccessor2 = (LevelAccessor)level;
                    BlockPos blockPos = this.getBlockPos().offset(xi, yi, zi);
                    Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"offset(...)");
                    BlockBreakHelper.INSTANCE.tryBreakCircuit(levelAccessor2, blockPos);
                }
            }
        }
        if (despawnTimer + 1 > 1200) {
            this.discard();
            ((ServerLevel)level).sendParticles((ParticleOptions)TBSParticleTypes.PARTICLE_OF_CURVED.get(), this.getX(), this.getY(), this.getZ(), 55, 3.0, 3.0, 3.0, 0.0);
        }
        if ((double)this.random.nextFloat() < 0.001) {
            BlockHitResult rayCast = ((ServerLevel)level).clip(new ClipContext(this.getEyePosition(1.0f), this.getEyePosition(1.0f).add(this.getViewVector(1.0f).scale(-10.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this));
            this.teleportTo(rayCast.getBlockPos().getX(), this.getY(), rayCast.getBlockPos().getZ());
        }
        if (((ServerLevel)level).getBlockState(BlockPos.containing((double)this.getX(), (double)this.getY(), (double)this.getZ())).canOcclude()) {
            this.teleportTo(this.getX(), this.getY() + 1.0, this.getZ());
        }
        boolean bl = (serverPlayer = EntityFinder.INSTANCE.findClosestPlayerInRange((ServerLevel)level, new Vec3(this.getX(), this.getY(), this.getZ()), (Number)4000.0)) != null && (serverPlayer = serverPlayer.gameMode) != null ? serverPlayer.isCreative() : false;
        if (bl) {
            this.discard();
        }
        this.refreshDimensions();
    }

    @Override
    @Nullable
    public PlayState movementPredicate(@NotNull AnimationState<?> event) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        if (Intrinsics.areEqual((Object)this.getAnimProcedure(), (Object)"empty")) {
            if (event.isMoving() || event.getLimbSwingAmount() <= -0.15f || event.getLimbSwingAmount() >= 0.15f) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("chase"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("angry_curved_idle"));
        }
        return PlayState.STOP;
    }

    @Override
    public void callFinalizeSpawn(@NotNull FinalizeSpawnEvent event) {
        FinalizedSpawn.DefaultImpls.callFinalizeSpawn(this, event);
    }

    private static final void die$lambda$1(CurvedEntity this$0) {
        LevelExt.chat$default(LevelExt.INSTANCE, (LevelAccessor)this$0.getLevel(), (Component)TBSLang.INSTANCE.getCURVED_LEAVE(), false, 2, null);
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.defineId(CurvedEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(...)");
        DESPAWN_TIMER = entityDataAccessor;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Ldev/wendigodrip/thebrokenscript/entity/CurvedEntity$Companion;", "", "<init>", "()V", "DESPAWN_TIMER", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "getDESPAWN_TIMER", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "createAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "thebrokenscript"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDataAccessor<Integer> getDESPAWN_TIMER() {
            return DESPAWN_TIMER;
        }

        @NotNull
        public final AttributeSupplier.Builder createAttributes() {
            AttributeSupplier.Builder builder = Monster.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.4).add(Attributes.MAX_HEALTH, 45.0).add(Attributes.ARMOR, 5.0).add(Attributes.ATTACK_DAMAGE, 50.0).add(Attributes.FOLLOW_RANGE, 916.0).add(Attributes.KNOCKBACK_RESISTANCE, 10.0).add(Attributes.ATTACK_KNOCKBACK, 1.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

