/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.block.entity;

import java.util.Collection;
import java.util.stream.IntStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0014J\b\u0010\u001b\u001a\u00020\u0016H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020 H\u0014J\b\u0010!\u001a\u00020\u001aH\u0016J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0014J\u0016\u0010#\u001a\u00020\u000f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0014J\u0018\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\rH\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0016J \u0010+\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\r2\u0006\u0010,\u001a\u00020*H\u0016J\"\u0010-\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00162\u0006\u0010&\u001a\u00020\r2\b\u0010,\u001a\u0004\u0018\u00010*H\u0016R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Ldev/wendigodrip/thebrokenscript/block/entity/WhiteBlockEntity;", "Lnet/minecraft/world/level/block/entity/RandomizableContainerBlockEntity;", "Lnet/minecraft/world/WorldlyContainer;", "type", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "position", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "stacks", "Lnet/minecraft/core/NonNullList;", "Lnet/minecraft/world/item/ItemStack;", "loadAdditional", "", "compound", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "saveAdditional", "getContainerSize", "", "isEmpty", "", "getDefaultName", "Lnet/minecraft/network/chat/Component;", "getMaxStackSize", "createMenu", "Lnet/minecraft/world/inventory/ChestMenu;", "id", "inventory", "Lnet/minecraft/world/entity/player/Inventory;", "getDisplayName", "getItems", "setItems", "canPlaceItem", "index", "stack", "getSlotsForFace", "", "side", "Lnet/minecraft/core/Direction;", "canTakeItemThroughFace", "direction", "canPlaceItemThroughFace", "thebrokenscript"})
@SourceDebugExtension(value={"SMAP\nWhiteBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WhiteBlockEntity.kt\ndev/wendigodrip/thebrokenscript/block/entity/WhiteBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,57:1\n1734#2,3:58\n1#3:61\n*S KotlinDebug\n*F\n+ 1 WhiteBlockEntity.kt\ndev/wendigodrip/thebrokenscript/block/entity/WhiteBlockEntity\n*L\n42#1:58,3\n*E\n"})
public final class WhiteBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    @NotNull
    private NonNullList<ItemStack> stacks;

    public WhiteBlockEntity(@NotNull BlockEntityType<WhiteBlockEntity> type, @NotNull BlockPos position, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, position, state);
        NonNullList nonNullList = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
        Intrinsics.checkNotNullExpressionValue((Object)nonNullList, (String)"withSize(...)");
        this.stacks = nonNullList;
    }

    protected void loadAdditional(@NotNull CompoundTag compound, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.loadAdditional(compound, registries);
        if (!this.tryLoadLootTable(compound)) {
            this.stacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        }
        ContainerHelper.loadAllItems((CompoundTag)compound, this.stacks, (HolderLookup.Provider)registries);
    }

    protected void saveAdditional(@NotNull CompoundTag compound, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        super.saveAdditional(compound, registries);
        if (!this.trySaveLootTable(compound)) {
            ContainerHelper.saveAllItems((CompoundTag)compound, this.stacks, (HolderLookup.Provider)registries);
        }
    }

    public int getContainerSize() {
        return this.stacks.size();
    }

    public boolean isEmpty() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = (Iterable)this.stacks;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ItemStack it = (ItemStack)element$iv;
                    boolean bl2 = false;
                    if (it.isEmpty()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    protected Component getDefaultName() {
        MutableComponent mutableComponent = Component.literal((String)"white");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
        return (Component)mutableComponent;
    }

    public int getMaxStackSize() {
        return 64;
    }

    @NotNull
    protected ChestMenu createMenu(int id, @NotNull Inventory inventory) {
        Intrinsics.checkNotNullParameter((Object)inventory, (String)"inventory");
        ChestMenu chestMenu = ChestMenu.threeRows((int)id, (Inventory)inventory);
        Intrinsics.checkNotNullExpressionValue((Object)chestMenu, (String)"threeRows(...)");
        return chestMenu;
    }

    @NotNull
    public Component getDisplayName() {
        MutableComponent mutableComponent = Component.literal((String)"OUTSIDE");
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
        return (Component)mutableComponent;
    }

    @NotNull
    protected NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    protected void setItems(@NotNull NonNullList<ItemStack> stacks) {
        Intrinsics.checkNotNullParameter(stacks, (String)"stacks");
        WhiteBlockEntity $this$setItems_u24lambda_u241 = this;
        boolean bl = false;
        $this$setItems_u24lambda_u241.stacks = stacks;
    }

    public boolean canPlaceItem(int index, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return true;
    }

    @NotNull
    public int[] getSlotsForFace(@NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        int[] nArray = IntStream.range(0, this.getContainerSize()).toArray();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"toArray(...)");
        return nArray;
    }

    public boolean canTakeItemThroughFace(int index, @NotNull ItemStack stack, @NotNull Direction direction) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
        return true;
    }

    public boolean canPlaceItemThroughFace(int index, @NotNull ItemStack stack, @Nullable Direction direction) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return this.canPlaceItem(index, stack);
    }
}

