/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.block;

import dev.wendigodrip.thebrokenscript.TheBrokenScript;
import dev.wendigodrip.thebrokenscript.api.ext.BlockPosExt;
import dev.wendigodrip.thebrokenscript.api.ext.EntityExt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Portal;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0014J \u0010\u000e\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J(\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0014J \u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006#"}, d2={"Ldev/wendigodrip/thebrokenscript/block/ExitBlock;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/Portal;", "properties", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "skipRendering", "", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "adjacentBlockState", "side", "Lnet/minecraft/core/Direction;", "propagatesSkylightDown", "reader", "Lnet/minecraft/world/level/BlockGetter;", "pos", "Lnet/minecraft/core/BlockPos;", "getLightBlock", "", "worldIn", "getVisualShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "level", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "entityInside", "", "Lnet/minecraft/world/level/Level;", "entity", "Lnet/minecraft/world/entity/Entity;", "getPortalDestination", "Lnet/minecraft/world/level/portal/DimensionTransition;", "Lnet/minecraft/server/level/ServerLevel;", "thebrokenscript"})
public final class ExitBlock
extends Block
implements Portal {
    public ExitBlock(@NotNull BlockBehaviour.Properties properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(properties);
    }

    protected boolean skipRendering(@NotNull BlockState state, @NotNull BlockState adjacentBlockState, @NotNull Direction side) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)adjacentBlockState, (String)"adjacentBlockState");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        return adjacentBlockState.is((Block)this) || super.skipRendering(state, adjacentBlockState, side);
    }

    protected boolean propagatesSkylightDown(@NotNull BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return true;
    }

    protected int getLightBlock(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return 0;
    }

    @NotNull
    protected VoxelShape getVisualShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VoxelShape voxelShape = Shapes.empty();
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"empty(...)");
        return voxelShape;
    }

    protected void entityInside(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        ResourceKey dimensionEntity;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!(!entity.canUsePortal(false) || !Shapes.joinIsNotEmpty((VoxelShape)Shapes.create((AABB)entity.getBoundingBox().move(BlockPosExt.INSTANCE.negate(pos))), (VoxelShape)state.getShape((BlockGetter)level, pos), (BooleanOp)BooleanOp.AND) || Intrinsics.areEqual((Object)(dimensionEntity = entity.level().dimension()), (Object)Level.OVERWORLD) && Intrinsics.areEqual((Object)dimensionEntity, (Object)Level.END) && Intrinsics.areEqual((Object)dimensionEntity, (Object)Level.NETHER))) {
            entity.setAsInsidePortal((Portal)this, pos);
            Player player = entity.level().getNearestPlayer(entity, 5.0);
            TheBrokenScript.INSTANCE.queueServerWork$thebrokenscript(35, () -> ExitBlock.entityInside$lambda$0(player, entity));
        }
    }

    @NotNull
    public DimensionTransition getPortalDestination(@NotNull ServerLevel level, @NotNull Entity entity, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return new DimensionTransition(level.getServer().overworld(), pos.getCenter(), entity.getDeltaMovement(), entity.getYRot(), entity.getXRot(), DimensionTransition.PLAY_PORTAL_SOUND.then(DimensionTransition.PLACE_PORTAL_TICKET));
    }

    private static final void entityInside$lambda$0(Player $player, Entity $entity) {
        block1: {
            Player player = $player;
            if (player != null) {
                Entity entity = (Entity)player;
                BlockPos blockPos = $entity.blockPosition();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"blockPosition(...)");
                EntityExt.INSTANCE.teleport(entity, BlockPosExt.INSTANCE.withY(blockPos, 100));
            }
            Player player2 = $player;
            if (player2 == null) break block1;
            player2.addEffect(new MobEffectInstance(MobEffects.SLOW_FALLING, 420, 1, false, false));
        }
    }
}

