/*
 * Decompiled with CFR 0.152.
 */
package dev.wendigodrip.thebrokenscript.behaviors;

import dev.wendigodrip.thebrokenscript.api.entity.base.BaseMonster;
import dev.wendigodrip.thebrokenscript.api.ext.BlockPosExt;
import dev.wendigodrip.thebrokenscript.api.ext.EntityExt;
import dev.wendigodrip.thebrokenscript.api.ext.EntityFinder;
import dev.wendigodrip.thebrokenscript.api.ext.LevelExt;
import dev.wendigodrip.thebrokenscript.api.ext.TagExt;
import dev.wendigodrip.thebrokenscript.registry.TBSLang;
import dev.wendigodrip.thebrokenscript.registry.TBSSounds;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetTitleTextPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Ldev/wendigodrip/thebrokenscript/behaviors/NullTitleShowerBehavior;", "", "<init>", "()V", "tick", "", "level", "Lnet/minecraft/world/level/LevelAccessor;", "entity", "Ldev/wendigodrip/thebrokenscript/api/entity/base/BaseMonster;", "thebrokenscript"})
public final class NullTitleShowerBehavior {
    @NotNull
    public static final NullTitleShowerBehavior INSTANCE = new NullTitleShowerBehavior();

    private NullTitleShowerBehavior() {
    }

    public final void tick(@NotNull LevelAccessor level, @NotNull BaseMonster entity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerPlayer player = EntityFinder.INSTANCE.findClosestPlayerInRange((ServerLevel)level, entity.getPos(), (Number)1000.0);
        if (player != null) {
            entity.setTarget((LivingEntity)player);
            if (((ServerLevel)level).getBlockState(entity.getBlockPos()).canOcclude()) {
                Entity entity2 = (Entity)entity;
                BlockPos blockPos = entity.getBlockPos().above();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"above(...)");
                EntityExt.INSTANCE.teleport(entity2, blockPos);
            }
            player.setGameMode(GameType.SURVIVAL);
            CompoundTag compoundTag = entity.getPersistentData();
            Intrinsics.checkNotNullExpressionValue((Object)compoundTag, (String)"getPersistentData(...)");
            double timer = TagExt.INSTANCE.addDouble(compoundTag, "timer", 1.0);
            if (timer == 15.0) {
                entity.getPersistentData().putDouble("timer", 0.0);
                BlockHitResult rayCast = entity.level().clip(new ClipContext(entity.getEyePosition(1.0f), entity.getEyePosition(1.0f).add(entity.getViewVector(1.0f).scale(10.0)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)entity));
                entity.teleportTo(rayCast.getBlockPos().getX(), entity.getPos().y, rayCast.getBlockPos().getZ());
                entity.addEffect(new MobEffectInstance(MobEffects.INVISIBILITY, 10, 1, false, false));
            }
            entity.lookAt(EntityAnchorArgument.Anchor.EYES, player.position().add(0.0, 1.0, 0.0));
            if ((double)((ServerLevel)level).random.nextFloat() < 0.1) {
                EntityExt.INSTANCE.teleport((Entity)entity, BlockPosExt.INSTANCE.withY(entity.getBlockPos(), player.getY()));
            }
        }
        if (((ServerLevel)level).random.nextBoolean()) {
            LevelExt.INSTANCE.tryBroadcastPacketInRange(level, entity.getPos(), 50, (Packet)new ClientboundSetTitleTextPacket((Component)CollectionsKt.random((Collection)TBSLang.INSTANCE.getNULL_TITLES(), (Random)((Random)Random.Default))));
        }
        Vec3 vec3 = entity.getPos();
        Number number = 50;
        Object object = TBSSounds.NULL_IS_HERE_LOOP.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        LevelExt.tryBroadcastSoundInRange$default(LevelExt.INSTANCE, level, vec3, number, (SoundEvent)object, 555.0f, 0.0f, null, 32, null);
    }
}

