/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.tier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import snownee.kiwi.util.codec.DeferredIngredient;

public class SimpleTier
implements Tier {
    public static final MapCodec<SimpleTier> DIRECT_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.BLOCK).fieldOf("incorrect_blocks_for_drops").forGetter(SimpleTier::getIncorrectBlocksForDrops), (App)Codec.INT.fieldOf("uses").forGetter(SimpleTier::getUses), (App)Codec.FLOAT.fieldOf("speed").forGetter(SimpleTier::getSpeed), (App)Codec.FLOAT.fieldOf("attack_damage_bonus").forGetter(SimpleTier::getAttackDamageBonus), (App)Codec.INT.fieldOf("enchantment_value").forGetter(SimpleTier::getEnchantmentValue), (App)DeferredIngredient.CODEC.fieldOf("repair_ingredient").forGetter(it -> it.repairIngredient)).apply((Applicative)instance, SimpleTier::new));
    private final TagKey<Block> incorrectBlocksForDrops;
    private final int uses;
    private final float speed;
    private final float attackDamageBonus;
    private final int enchantmentValue;
    private final DeferredIngredient repairIngredient;

    public SimpleTier(TagKey<Block> incorrectBlocksForDrops, int uses, float speed, float attackDamageBonus, int enchantmentValue, DeferredIngredient repairIngredient) {
        this.incorrectBlocksForDrops = incorrectBlocksForDrops;
        this.uses = uses;
        this.speed = speed;
        this.attackDamageBonus = attackDamageBonus;
        this.enchantmentValue = enchantmentValue;
        this.repairIngredient = repairIngredient;
    }

    public int getUses() {
        return this.uses;
    }

    public float getSpeed() {
        return this.speed;
    }

    public float getAttackDamageBonus() {
        return this.attackDamageBonus;
    }

    public TagKey<Block> getIncorrectBlocksForDrops() {
        return this.incorrectBlocksForDrops;
    }

    public int getEnchantmentValue() {
        return this.enchantmentValue;
    }

    @NotNull
    public Ingredient getRepairIngredient() {
        return this.repairIngredient.get();
    }

    public String toString() {
        return "SimpleTier[incorrectBlocksForDrops=" + String.valueOf(this.incorrectBlocksForDrops) + ", uses=" + this.uses + ", speed=" + this.speed + ", attackDamageBonus=" + this.attackDamageBonus + ", enchantmentValue=" + this.enchantmentValue + ", repairIngredient=" + String.valueOf(this.repairIngredient) + "]";
    }
}

