/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.autocomplete.suggestions;

import com.mt1006.nbt_ac.autocomplete.CustomTagParser;
import com.mt1006.nbt_ac.autocomplete.DataComponentManager;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestionManager;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestions;
import com.mt1006.nbt_ac.autocomplete.SuggestionList;
import com.mt1006.nbt_ac.autocomplete.suggestions.CustomSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.IdSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.NbtSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.StringSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.TagIdSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.TagSuggestion;
import com.mt1006.nbt_ac.config.ModConfig;
import com.mt1006.nbt_ac.mixin.fields.DecoratedPotPatternsFields;
import com.mt1006.nbt_ac.mixin.fields.FontManagerFields;
import com.mt1006.nbt_ac.mixin.fields.KeyMappingFields;
import com.mt1006.nbt_ac.mixin.fields.MinecraftFields;
import com.mt1006.nbt_ac.mixin.fields.TextColorFields;
import com.mt1006.nbt_ac.utils.Fields;
import com.mt1006.nbt_ac.utils.RegistryUtils;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.font.FontManager;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.JukeboxSongs;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.item.armortrim.TrimPatterns;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import org.jetbrains.annotations.Nullable;

public enum NbtSuggestionSubtype {
    NONE,
    ENUM,
    DESCRIBED_ENUM,
    BLOCK_STATE_ENUM,
    ORDERED_ENUM,
    REQUIRED_ID,
    TAG,
    TAG_WITH_ID,
    BLOCK_STATE_TAG,
    SPAWN_EGG,
    REGISTRY_ID,
    REGISTRY_KEY,
    ITEM_COMPONENTS,
    RECIPE,
    LOOT_TABLE,
    BANNER_PATTERN,
    MAP_DECORATION_TYPE,
    FONT,
    RANDOM_UUID,
    LONG_SEED,
    INVENTORY_SLOT,
    TRANSLATION_KEY,
    KEYBIND,
    JSON_TEXT,
    JSON_TEXT_COMPOUND,
    JSON_TEXT_COLOR,
    JSON_STYLE_COMPOUND,
    ENTITY_SELECTOR,
    HOVER_EVENT_CONTENTS,
    DYE_COLOR,
    EMPTY_COMPOUND,
    ENCHANTMENTS,
    MAP_DECORATIONS,
    POT_DECORATION,
    TRIM_PATTERN,
    TRIM_MATERIAL,
    JUKEBOX_SONG;

    private static final List<String> JSON_TEXT_TYPE_SPECIFIC;
    private static final List<String> JSON_TEXT_TYPE_HAS_SEPARATOR;
    private static final Random rng;

    public String getName() {
        return this.name().toLowerCase();
    }

    public static NbtSuggestionSubtype fromName(String name) {
        try {
            return NbtSuggestionSubtype.valueOf(name.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            return NONE;
        }
    }

    public <T> boolean getSubtypeSuggestions(NbtSuggestion suggestion, SuggestionList suggestionList, @Nullable String data, CustomTagParser.Type parserType) {
        switch (this.ordinal()) {
            case 1: {
                if (data == null) break;
                suggestionList.clear();
                for (String substring : data.split(";")) {
                    suggestionList.add(CustomSuggestion.fromType(substring, null, suggestion.type, parserType, 0));
                }
                return true;
            }
            case 2: {
                if (data == null) break;
                suggestionList.clear();
                String suggestionText = null;
                for (String substring : data.split(";")) {
                    if (suggestionText == null) {
                        suggestionText = substring;
                        continue;
                    }
                    suggestionList.add(CustomSuggestion.fromType(suggestionText, String.format("<%s>", substring), suggestion.type, parserType, 0));
                    suggestionText = null;
                }
                return true;
            }
            case 3: {
                if (data == null) break;
                suggestionList.clear();
                char quote = ModConfig.getDefaultQuotationMark(false);
                for (String substring : data.split(";")) {
                    suggestionList.addRaw(String.format("%c%s%c", Character.valueOf(quote), substring, Character.valueOf(quote)), null);
                }
                return true;
            }
            case 4: {
                if (data == null) break;
                suggestionList.clear();
                int priority = 99;
                for (String substring : data.split(";")) {
                    suggestionList.add(CustomSuggestion.fromType(substring, null, suggestion.type, parserType, priority--));
                }
                return true;
            }
            case 5: {
                if (data == null) break;
                suggestionList.clear();
                suggestionList.add(new IdSuggestion(ResourceLocation.parse((String)data), "#[required_id]", parserType));
                return true;
            }
            case 10: 
            case 11: {
                if (data == null) break;
                try {
                    ResourceLocation registryLocation = ResourceLocation.parse((String)data);
                    Registry registry = (Registry)RegistryUtils.REGISTRY.get(registryLocation);
                    if (registry == null) break;
                    suggestionList.clear();
                    if (this == REGISTRY_ID) {
                        for (Object object : registry) {
                            suggestionList.addRaw(Integer.toString(registry.getId(object)), "\"" + String.valueOf(registry.getKey(object)) + "\" [#" + registryLocation.getPath() + "]");
                        }
                    } else {
                        for (Object object : registry) {
                            suggestionList.add(new IdSuggestion(registry.getKey(object), "[#" + registryLocation.getPath() + "]", parserType));
                        }
                    }
                }
                catch (Exception registryLocation) {
                    // empty catch block
                }
                return true;
            }
            case 13: {
                ClientLevel recipeLevel = Minecraft.getInstance().level;
                if (recipeLevel == null) break;
                suggestionList.clear();
                for (ResourceLocation id : (ResourceLocation[])recipeLevel.getRecipeManager().getRecipeIds().toArray(ResourceLocation[]::new)) {
                    suggestionList.add(new IdSuggestion(id, null, parserType));
                }
                return true;
            }
            case 14: {
                IntegratedServer singlePlayerServer = Minecraft.getInstance().getSingleplayerServer();
                if (singlePlayerServer == null) break;
                suggestionList.clear();
                for (ResourceLocation id : singlePlayerServer.reloadableRegistries().getKeys(Registries.LOOT_TABLE)) {
                    suggestionList.add(new IdSuggestion(id, null, parserType));
                }
                return true;
            }
            case 15: {
                suggestionList.clear();
                List<ResourceKey> bannerPatterns = Fields.getStaticFields(BannerPatterns.class, ResourceKey.class);
                bannerPatterns.forEach(key -> suggestionList.add(new IdSuggestion(key.location(), "[#banner_pattern]", parserType)));
                return true;
            }
            case 16: {
                suggestionList.clear();
                List<Holder> decorationTypes = Fields.getStaticFields(MapDecorationTypes.class, Holder.class);
                for (Holder holder : decorationTypes) {
                    ResourceKey key2 = holder.unwrapKey().orElse(null);
                    StringSuggestion customSuggestion = key2 != null ? new IdSuggestion(key2.location(), "[#banner_pattern]", parserType) : new StringSuggestion("_error", null, parserType, 9999);
                    suggestionList.add(customSuggestion);
                }
                return true;
            }
            case 17: {
                suggestionList.clear();
                FontManager fontManager = ((MinecraftFields)Minecraft.getInstance()).getFontManager();
                for (ResourceLocation id : ((FontManagerFields)fontManager).getFontSets().keySet()) {
                    suggestionList.add(new IdSuggestion(id, "[#font]", parserType));
                }
                return true;
            }
            case 23: {
                suggestionList.clear();
                NbtSuggestionSubtype.getJsonTextPrefixSuggestions(suggestionList, true);
                return true;
            }
            case 25: {
                suggestionList.clear();
                suggestionList.addRaw("\"#", "[#json_color]", 1);
                Map<String, TextColor> colorMap = TextColorFields.getNAMED_COLORS();
                if (colorMap == null) {
                    return true;
                }
                for (Map.Entry<String, TextColor> entry : colorMap.entrySet()) {
                    String subtext = String.format("(#%06X) [#json_color]", entry.getValue().getValue());
                    suggestionList.add(new StringSuggestion(entry.getKey(), subtext, parserType));
                }
                return true;
            }
            case 18: {
                suggestionList.clear();
                UUID randomUUID = UUID.randomUUID();
                int uuidInt0 = (int)randomUUID.getLeastSignificantBits();
                int uuidInt1 = (int)(randomUUID.getLeastSignificantBits() >>> 32);
                int uuidInt2 = (int)randomUUID.getMostSignificantBits();
                int uuidInt3 = (int)(randomUUID.getMostSignificantBits() >>> 32);
                String uuidString = String.format("[I;%d, %d, %d, %d]", uuidInt3, uuidInt2, uuidInt1, uuidInt0);
                suggestionList.addRaw(uuidString, "[#random_uuid]");
                return true;
            }
            case 19: {
                suggestionList.clear();
                long random = rng.nextLong();
                if (random == 0L) {
                    random = 123L;
                }
                suggestionList.addRaw("0", "(random) [#seed]", 1);
                suggestionList.addRaw(random + "l", "(constant) [#seed]");
                return true;
            }
            case 20: {
                int i;
                suggestionList.clear();
                NbtSuggestion.Type type = suggestion.type;
                for (i = 0; i < 9; ++i) {
                    String subtext = String.format("(Hotbar %d) [#inventory_slot]", i + 1);
                    suggestionList.addRaw(String.format("%d%s", i, type.suffix), subtext);
                }
                for (i = 9; i < 35; ++i) {
                    int row = (i - 9) / 9 + 1;
                    int column = (i - 9) % 9 + 1;
                    String subtext = String.format("(Storage %d:%d) [#inventory_slot]", row, column);
                    suggestionList.addRaw(String.format("%d%s", i, type.suffix), subtext);
                }
                suggestionList.addRaw("100" + type.suffix, "(Feet) [#inventory_slot]");
                suggestionList.addRaw("101" + type.suffix, "(Legs) [#inventory_slot]");
                suggestionList.addRaw("102" + type.suffix, "(Chest) [#inventory_slot]");
                suggestionList.addRaw("103" + type.suffix, "(Head) [#inventory_slot]");
                suggestionList.addRaw("-106" + type.suffix, "(Off-hand) [#inventory_slot]");
                return true;
            }
            case 21: {
                return false;
            }
            case 22: {
                suggestionList.clear();
                Map<String, KeyMapping> keyMap = KeyMappingFields.getALL();
                if (keyMap == null) break;
                for (String str : keyMap.keySet()) {
                    String subtext = "\"" + Component.translatable((String)str).getString() + "\" [#keybind]";
                    suggestionList.add(new StringSuggestion(str, subtext, parserType));
                }
                return true;
            }
            case 27: {
                suggestionList.clear();
                suggestionList.add(new StringSuggestion("@p", "[#entity_selector]", parserType));
                suggestionList.add(new StringSuggestion("@a", "[#entity_selector]", parserType));
                suggestionList.add(new StringSuggestion("@r", "[#entity_selector]", parserType));
                suggestionList.add(new StringSuggestion("@s", "[#entity_selector]", parserType));
                suggestionList.add(new StringSuggestion("@e", "[#entity_selector]", parserType));
                suggestionList.add(new StringSuggestion("@n", "[#entity_selector]", parserType));
                return true;
            }
            case 29: {
                suggestionList.clear();
                for (DyeColor color : DyeColor.values()) {
                    suggestionList.add(new StringSuggestion(color.getName(), "[#dye_color]", parserType));
                }
                return true;
            }
            case 30: {
                suggestionList.clear();
                suggestionList.addRaw("{}", "[#empty_compound]");
                return true;
            }
            case 33: {
                suggestionList.clear();
                suggestionList.add(new IdSuggestion(RegistryUtils.ITEM.getKey(Items.BRICK), "[#pot_decoration]", parserType, 1));
                Map<Item, ResourceKey<String>> itemToPotTexture = DecoratedPotPatternsFields.getITEM_TO_POT_TEXTURE();
                if (itemToPotTexture == null) {
                    return true;
                }
                for (Item item : itemToPotTexture.keySet()) {
                    suggestionList.add(new IdSuggestion(RegistryUtils.ITEM.getKey(item), "[#pot_decoration]", parserType));
                }
                return true;
            }
            case 34: {
                suggestionList.clear();
                List<ResourceKey> trimPatterns = Fields.getStaticFields(TrimPatterns.class, ResourceKey.class);
                trimPatterns.forEach(key -> suggestionList.add(new IdSuggestion(key.location(), "[#trim_pattern]", parserType)));
                return true;
            }
            case 35: {
                suggestionList.clear();
                List<ResourceKey> trimMaterial = Fields.getStaticFields(TrimMaterials.class, ResourceKey.class);
                trimMaterial.forEach(key -> suggestionList.add(new IdSuggestion(key.location(), "[#trim_material]", parserType)));
                return true;
            }
            case 36: {
                suggestionList.clear();
                List<ResourceKey> jukeboxSong = Fields.getStaticFields(JukeboxSongs.class, ResourceKey.class);
                jukeboxSong.forEach(key -> suggestionList.add(new IdSuggestion(key.location(), "[#jukebox_song]", parserType)));
                return true;
            }
        }
        return false;
    }

    public <T extends Comparable<T>> void getSubtypeTagSuggestions(SuggestionList suggestionList, NbtSuggestion.ParentInfo parentInfo, @Nullable String data, CustomTagParser.Type parserType) {
        switch (this.ordinal()) {
            case 6: 
            case 7: {
                int dataSlashPos;
                if (data == null) break;
                data = data.replace("block/item/", "block/");
                data = data.replace("entity/item/", "entity/");
                NbtSuggestions tagSuggestions = NbtSuggestionManager.get(data);
                suggestionList.addAll(tagSuggestions, data, parserType);
                if (this != TAG_WITH_ID || (dataSlashPos = data.indexOf(47)) == -1) break;
                NbtSuggestion tempSuggestion = new NbtSuggestion("id", NbtSuggestion.Type.STRING);
                tempSuggestion.subtype = REQUIRED_ID;
                tempSuggestion.subtypeData = data.substring(dataSlashPos + 1);
                suggestionList.add(new TagSuggestion(tempSuggestion, parserType, 100));
                break;
            }
            case 8: {
                try {
                    if (data == null) break;
                    if (data.startsWith("block/")) {
                        data = data.substring(6);
                    } else if (data.startsWith("item/")) {
                        data = data.substring(5);
                    }
                    Item blockItem = RegistryUtils.ITEM.get(ResourceLocation.parse((String)data));
                    if (!(blockItem instanceof BlockItem)) break;
                    for (Property property : ((BlockItem)blockItem).getBlock().defaultBlockState().getProperties()) {
                        NbtSuggestion nbtSuggestion = new NbtSuggestion(property.getName(), NbtSuggestion.Type.STRING);
                        nbtSuggestion.subtype = BLOCK_STATE_ENUM;
                        StringBuilder enumStringBuilder = new StringBuilder();
                        for (Comparable possibleValue : property.getPossibleValues()) {
                            enumStringBuilder.append(property.getName(possibleValue)).append(";");
                        }
                        nbtSuggestion.subtypeData = enumStringBuilder.toString();
                        suggestionList.add(new TagSuggestion(nbtSuggestion, parserType));
                    }
                    break;
                }
                catch (Exception blockItem) {
                    break;
                }
            }
            case 9: {
                try {
                    Item item;
                    if (data == null) break;
                    if (data.startsWith("item/")) {
                        data = data.substring(5);
                    }
                    if (!((item = RegistryUtils.ITEM.get(ResourceLocation.parse((String)data))) instanceof SpawnEggItem)) break;
                    String key = RegistryUtils.ENTITY_TYPE.getKey(((SpawnEggItem)item).getType(null)).toString();
                    NbtSuggestions spawnEggSuggestions = NbtSuggestionManager.get("entity/" + key);
                    suggestionList.addAll(spawnEggSuggestions, data, parserType);
                }
                catch (Exception item) {}
                break;
            }
            case 12: {
                if (data == null) break;
                DataComponentManager.loadSuggestions(suggestionList, "", Set.of(), RegistryUtils.ITEM.get(data), parserType, false);
                break;
            }
            case 24: {
                NbtSuggestionSubtype.getJsonCompoundSuggestions(suggestionList, parentInfo, parserType);
                break;
            }
            case 26: {
                suggestionList.addAll(NbtSuggestionManager.get("json_text/style"), parserType);
                break;
            }
            case 28: {
                NbtSuggestionSubtype.getHoverEventContentsSuggestions(suggestionList, parentInfo, data, parserType);
                break;
            }
            case 31: {
                suggestionList.clear();
                List<ResourceKey> enchantments = Fields.getStaticFields(Enchantments.class, ResourceKey.class);
                for (ResourceKey resourceKey : enchantments) {
                    ResourceLocation id = resourceKey.location();
                    NbtSuggestion tempSuggestion = new NbtSuggestion(id.toString(), NbtSuggestion.Type.INT);
                    suggestionList.add(new TagIdSuggestion(tempSuggestion, id, parserType, true));
                }
                break;
            }
            case 32: {
                String decorationId = Long.toString(Math.abs(rng.nextInt()), Math.min(36, 36));
                NbtSuggestion tempSuggestion = new NbtSuggestion(decorationId, NbtSuggestion.Type.COMPOUND);
                tempSuggestion.subtype = TAG;
                tempSuggestion.subtypeData = "compound/nbt_ac:map_decoration";
                suggestionList.add(new TagSuggestion(tempSuggestion, parserType));
                if (parentInfo.tagMap == null) break;
                for (String tag : parentInfo.tagMap.keySet()) {
                    NbtSuggestion tempOldSuggestion = new NbtSuggestion(tag, NbtSuggestion.Type.COMPOUND);
                    tempOldSuggestion.subtype = TAG;
                    tempOldSuggestion.subtypeData = "compound/nbt_ac:map_decoration";
                    suggestionList.add(new TagSuggestion(tempOldSuggestion, parserType));
                }
                break;
            }
        }
    }

    public static void getJsonTextPrefixSuggestions(SuggestionList suggestionList, boolean inner) {
        String jsonSuggestion;
        String string = jsonSuggestion = inner ? ModConfig.getJsonStringSuggestion() : "\"";
        if (jsonSuggestion != null) {
            suggestionList.addRaw(jsonSuggestion, "(simple string) [#json_text]", 3);
        }
        suggestionList.addRaw(inner ? "'{" : "{", "(json structure) [#json_text]", 2);
        suggestionList.addRaw(inner ? "'[" : "[", "(json list) [#json_text]", 1);
    }

    private static void getJsonCompoundSuggestions(SuggestionList suggestionList, NbtSuggestion.ParentInfo parentInfo, CustomTagParser.Type parserType) {
        suggestionList.addAll(NbtSuggestionManager.get("json_text/common"), parserType);
        suggestionList.addAll(NbtSuggestionManager.get("json_text/style"), parserType);
        String contentType = NbtSuggestionSubtype.jsonTextInit(suggestionList, parentInfo, parserType);
        for (String str : JSON_TEXT_TYPE_SPECIFIC) {
            int priority = contentType != null && !str.equals(contentType) ? -1 : 0;
            suggestionList.addAll(NbtSuggestionManager.get("json_text/type_specific/" + str), parserType, priority);
        }
        int priority = contentType != null && !JSON_TEXT_TYPE_HAS_SEPARATOR.contains(contentType) ? -1 : 0;
        suggestionList.addAll(NbtSuggestionManager.get("json_text/compound/separator"), parserType, priority);
    }

    @Nullable
    private static String jsonTextInit(SuggestionList suggestionList, NbtSuggestion.ParentInfo parentInfo, CustomTagParser.Type parserType) {
        Map<Object, Object> tagMap;
        NbtSuggestions initialContent = NbtSuggestionManager.get("json_text/initial_content");
        if (initialContent == null) {
            return null;
        }
        Map<Object, Object> map = tagMap = parentInfo.tagMap != null ? parentInfo.tagMap : Map.of();
        if (tagMap.containsKey("type")) {
            String valueType = (String)tagMap.get("type");
            NbtSuggestion typeSuggestion = initialContent.get("type");
            NbtSuggestion valueSuggestion = initialContent.get(valueType);
            if (typeSuggestion != null) {
                suggestionList.add(new TagSuggestion(typeSuggestion, parserType, 100));
            }
            if (valueSuggestion != null) {
                suggestionList.add(new TagSuggestion(valueSuggestion, parserType, 100));
            }
            for (NbtSuggestion suggestion : initialContent.getAll()) {
                if (suggestion == typeSuggestion || suggestion == valueSuggestion) continue;
                suggestionList.add(new TagSuggestion(suggestion, parserType, -1));
            }
            return valueType;
        }
        for (NbtSuggestion suggestion : initialContent.getAll()) {
            if (!tagMap.containsKey(suggestion.tag)) continue;
            suggestionList.addAll(initialContent, parserType, -1);
            return NbtSuggestionSubtype.jsonTextTypeFromTag(suggestion.tag);
        }
        suggestionList.addAll(initialContent, parserType, 100);
        return null;
    }

    private static String jsonTextTypeFromTag(String tag) {
        return tag.equals("translate") ? "translatable" : tag;
    }

    private static void getHoverEventContentsSuggestions(SuggestionList suggestionList, NbtSuggestion.ParentInfo parentInfo, @Nullable String data, CustomTagParser.Type parserType) {
        String hoverEvent;
        if (parentInfo.parentTagMap == null || !parentInfo.parentTagMap.containsKey("action")) {
            return;
        }
        switch (hoverEvent = parentInfo.parentTagMap.get("action")) {
            case "show_text": {
                JSON_TEXT_COMPOUND.getSubtypeTagSuggestions(suggestionList, parentInfo, data, parserType);
                break;
            }
            case "show_item": {
                suggestionList.addAll(NbtSuggestionManager.get("json_text/compound/hover_event_show_item"), parserType);
                break;
            }
            case "show_entity": {
                suggestionList.addAll(NbtSuggestionManager.get("json_text/compound/hover_event_show_entity"), parserType);
            }
        }
    }

    static {
        JSON_TEXT_TYPE_SPECIFIC = List.of("nbt", "translatable");
        JSON_TEXT_TYPE_HAS_SEPARATOR = List.of("nbt", "selector");
        rng = new Random();
    }
}

