/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.autocomplete.suggestions;

import com.mt1006.nbt_ac.autocomplete.CustomTagParser;
import com.mt1006.nbt_ac.autocomplete.suggestions.StringSuggestion;
import com.mt1006.nbt_ac.config.ModConfig;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class IdSuggestion
extends StringSuggestion {
    @Nullable
    private final String altText;

    public IdSuggestion(@Nullable ResourceLocation resLoc, @Nullable String subtext, CustomTagParser.Type parserType, int priority) {
        super(resLoc != null ? resLoc.toString() : "_error", subtext, parserType, parserType.requiresNamespace ? StringSuggestion.StringType.FULL_ID : StringSuggestion.StringType.ID, priority);
        boolean mcNamespaceHidden;
        boolean bl = mcNamespaceHidden = (Boolean)ModConfig.hideMcNamespaceInStrings.val != false && parserType.requiresNamespace;
        this.altText = resLoc != null && resLoc.getNamespace().equals("minecraft") ? (mcNamespaceHidden ? String.format("minecraft:%s", this.text) : resLoc.getPath()) : null;
    }

    public IdSuggestion(@Nullable ResourceLocation resLoc, @Nullable String subtext, CustomTagParser.Type parserType) {
        this(resLoc, subtext, parserType, 0);
    }

    @Override
    public boolean match(String str) {
        return str.equals(this.text) || str.equals(this.altText);
    }

    @Override
    public boolean matchUnfinished(String str) {
        return IdSuggestion.matchPrefix(this.text, str) || this.altText != null && IdSuggestion.matchPrefix(this.altText, str);
    }
}

