/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.autocomplete.loader.resourceloader;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mt1006.nbt_ac.NBTac;
import com.mt1006.nbt_ac.autocomplete.DataComponentManager;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestionManager;
import com.mt1006.nbt_ac.autocomplete.NbtSuggestions;
import com.mt1006.nbt_ac.autocomplete.loader.resourceloader.Prediction;
import com.mt1006.nbt_ac.autocomplete.loader.resourceloader.ResourceLoader;
import com.mt1006.nbt_ac.autocomplete.suggestions.NbtSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.NbtSuggestionSubtype;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class ParseJson {
    public static void parseAll() {
        ParseJson.parseTags();
        ParseJson.parseComponents();
        ParseJson.parsePredictions();
    }

    private static void parseTags() {
        for (ResourceLoader.TagStructure tag : ResourceLoader.tags) {
            try {
                ParseJson.parseObject(tag.id, tag.applyTo, tag.tags, true);
            }
            catch (Exception exception) {
                NBTac.LOGGER.warn("Failed to parse tag: {}", (Object)tag.id);
            }
        }
    }

    private static void parseComponents() {
        for (ResourceLoader.ComponentStructure component : ResourceLoader.components) {
            try {
                ParseJson.parseComponent(component.getId(), component.type, component.subtype, component.with, component.alwaysRelevant, component.getTags());
            }
            catch (Exception exception) {
                NBTac.LOGGER.warn("Failed to parse component: {}", (Object)component.getId());
            }
        }
    }

    private static void parsePredictions() {
        for (Pair<JsonArray, JsonArray> prediction : ResourceLoader.predictions) {
            try {
                new Prediction(prediction).execute();
            }
            catch (Exception exception) {
                NBTac.LOGGER.warn("Failed to parse prediction!");
            }
        }
    }

    private static void parseComponent(String id, String typeString, @Nullable String subtypeString, @Nullable String with, boolean alwaysRelevant, @Nullable JsonArray tags) {
        Pair<NbtSuggestion.Type, NbtSuggestion.Type> type = ParseJson.parseType(typeString);
        Pair<NbtSuggestionSubtype, String> subtype = ParseJson.parseSubtype(subtypeString);
        NbtSuggestions suggestions = tags != null ? ParseJson.parseObject(null, null, tags, false) : null;
        NbtSuggestion component = new NbtSuggestion(id, (NbtSuggestion.Type)((Object)type.getLeft()), NbtSuggestion.Source.DEFAULT, (NbtSuggestion.Type)((Object)type.getRight()));
        component.subtype = (NbtSuggestionSubtype)((Object)subtype.getLeft());
        component.subtypeData = (String)subtype.getRight();
        component.subcompound = suggestions;
        component.subtypeWith = with;
        if (alwaysRelevant) {
            component.setAlwaysRelevant();
        }
        DataComponentManager.componentMap.put(id, component);
    }

    private static NbtSuggestions parseObject(@Nullable String id, @Nullable JsonArray applyTo, JsonArray tags, boolean allowPredictions) {
        NbtSuggestions nbtSuggestions = new NbtSuggestions(allowPredictions);
        for (JsonElement tag : tags) {
            if (!(tag instanceof JsonObject)) continue;
            ParseJson.parseTag((JsonObject)tag, nbtSuggestions, allowPredictions);
        }
        if (applyTo != null) {
            for (JsonElement tagElement : applyTo) {
                if (!(tagElement instanceof JsonPrimitive) || !((JsonPrimitive)tagElement).isString()) continue;
                NbtSuggestionManager.add(tagElement.getAsString(), nbtSuggestions);
            }
        }
        if (id != null) {
            NbtSuggestionManager.add(id, nbtSuggestions);
        }
        return nbtSuggestions;
    }

    private static void parseTag(JsonObject suggestion, NbtSuggestions nbtSuggestions, boolean allowPredictions) {
        String tag = suggestion.get("tag").getAsString();
        Pair<NbtSuggestion.Type, NbtSuggestion.Type> type = ParseJson.parseType(suggestion.get("type").getAsString());
        Pair<NbtSuggestionSubtype, String> subtype = ParseJson.parseSubtype(suggestion.get("subtype"));
        String withString = null;
        JsonElement withElement = suggestion.get("with");
        if (withElement instanceof JsonPrimitive && ((JsonPrimitive)withElement).isString()) {
            withString = withElement.getAsString();
        }
        boolean recommended = false;
        JsonElement recommendedElement = suggestion.get("recommended");
        if (recommendedElement instanceof JsonPrimitive && ((JsonPrimitive)recommendedElement).isBoolean()) {
            recommended = recommendedElement.getAsBoolean();
        }
        NbtSuggestion newSuggestion = new NbtSuggestion(tag, (NbtSuggestion.Type)((Object)type.getLeft()));
        newSuggestion.listType = (NbtSuggestion.Type)((Object)type.getRight());
        newSuggestion.subtype = (NbtSuggestionSubtype)((Object)subtype.getLeft());
        newSuggestion.subtypeData = (String)subtype.getRight();
        newSuggestion.subtypeWith = withString;
        newSuggestion.recommended = recommended;
        JsonElement subcompoundElement = suggestion.get("tags");
        if (subcompoundElement instanceof JsonArray) {
            newSuggestion.subcompound = ParseJson.parseObject(null, null, (JsonArray)subcompoundElement, allowPredictions);
        }
        nbtSuggestions.add(newSuggestion);
    }

    public static Pair<NbtSuggestion.Type, NbtSuggestion.Type> parseType(String typeString) {
        int typeSlashPos = typeString.indexOf(47);
        if (typeSlashPos == -1) {
            return Pair.of((Object)((Object)NbtSuggestion.Type.fromName(typeString)), (Object)((Object)NbtSuggestion.Type.UNKNOWN));
        }
        return Pair.of((Object)((Object)NbtSuggestion.Type.fromName(typeString.substring(0, typeSlashPos))), (Object)((Object)NbtSuggestion.Type.fromName(typeString.substring(typeSlashPos + 1))));
    }

    private static Pair<NbtSuggestionSubtype, String> parseSubtype(@Nullable JsonElement subtypeElement) {
        String subtypeString = subtypeElement instanceof JsonPrimitive && ((JsonPrimitive)subtypeElement).isString() ? subtypeElement.getAsString() : null;
        return ParseJson.parseSubtype(subtypeString);
    }

    private static Pair<NbtSuggestionSubtype, String> parseSubtype(@Nullable String subtypeString) {
        if (subtypeString == null) {
            return Pair.of((Object)((Object)NbtSuggestionSubtype.NONE), null);
        }
        int subtypeSlashPos = subtypeString.indexOf(47);
        if (subtypeSlashPos == -1) {
            return Pair.of((Object)((Object)NbtSuggestionSubtype.fromName(subtypeString)), null);
        }
        return Pair.of((Object)((Object)NbtSuggestionSubtype.fromName(subtypeString.substring(0, subtypeSlashPos))), (Object)subtypeString.substring(subtypeSlashPos + 1));
    }
}

