/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.autocomplete;

import com.mt1006.nbt_ac.autocomplete.CustomTagParser;
import com.mt1006.nbt_ac.autocomplete.SuggestionList;
import com.mt1006.nbt_ac.autocomplete.loader.typeloader.TypeLoader;
import com.mt1006.nbt_ac.autocomplete.suggestions.ComponentSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.NbtSuggestion;
import com.mt1006.nbt_ac.autocomplete.suggestions.TagIdSuggestion;
import com.mt1006.nbt_ac.config.ModConfig;
import com.mt1006.nbt_ac.utils.Fields;
import com.mt1006.nbt_ac.utils.RegistryUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorStandItem;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.FireworkStarItem;
import net.minecraft.world.item.HangingEntityItem;
import net.minecraft.world.item.InstrumentItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.KnowledgeBookItem;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.MinecartItem;
import net.minecraft.world.item.OminousBottleItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TippedArrowItem;
import net.minecraft.world.item.WritableBookItem;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.PlayerHeadBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class DataComponentManager {
    private static final NbtSuggestion UNKNOWN_COMPONENT = new NbtSuggestion("nbt_ac:empty", NbtSuggestion.Type.UNKNOWN);
    public static final Map<String, NbtSuggestion> componentMap = new HashMap<String, NbtSuggestion>();

    public static void loadSuggestions(SuggestionList suggestionList, String str, Set<DataComponentType<?>> usedComponents, @Nullable Item item, @Nullable CustomTagParser.Type parserType, boolean addSuffix) {
        ArrayList entryList = new ArrayList();
        SharedSuggestionProvider.filterResources(RegistryUtils.DATA_COMPONENT_TYPE.entrySet(), (String)str, entry -> ((ResourceKey)entry.getKey()).location(), entryList::add);
        Set<DataComponentType<?>> predefinedComponents = DataComponentManager.getPredefinedComponents(item);
        Set<DataComponentType<?>> hardcodedRelevancy = DataComponentManager.getHardcodedRelevant(item);
        for (Map.Entry entry2 : entryList) {
            boolean relevant;
            ResourceLocation resLoc = ((ResourceKey)entry2.getKey()).location();
            DataComponentType componentType = (DataComponentType)entry2.getValue();
            if (componentType.codec() == null || usedComponents.contains(componentType)) continue;
            NbtSuggestion component = componentMap.get("item/" + String.valueOf(resLoc));
            if (component == null) {
                component = UNKNOWN_COMPONENT;
            }
            boolean bl = relevant = predefinedComponents.contains(componentType) || hardcodedRelevancy.contains(componentType) || component.isAlwaysRelevant();
            if (parserType != null) {
                suggestionList.add(new TagIdSuggestion(component, resLoc, parserType, relevant));
                continue;
            }
            String subtext = component.getSubtext();
            suggestionList.add(new ComponentSuggestion(resLoc, subtext, relevant, addSuffix));
        }
    }

    private static Set<DataComponentType<?>> getPredefinedComponents(@Nullable Item item) {
        if (item == null) {
            return Set.of();
        }
        return item.components().keySet();
    }

    private static Set<DataComponentType<?>> getHardcodedRelevant(@Nullable Item item) {
        if (item == null) {
            return Set.of();
        }
        HashSet relevant = new HashSet();
        if (((Boolean)ModConfig.showCustomDataAsRelevant.val).booleanValue()) {
            relevant.add(DataComponents.CUSTOM_DATA);
        }
        if (((Boolean)ModConfig.showCustomModelDataAsRelevant.val).booleanValue()) {
            relevant.add(DataComponents.CUSTOM_MODEL_DATA);
        }
        if (item.builtInRegistryHolder().is(ItemTags.DYEABLE)) {
            relevant.add(DataComponents.DYED_COLOR);
        }
        if (Fields.isMethodOverridden(Fields.itemAppendHoverTextMethodData, item, Item.class)) {
            relevant.add(DataComponents.HIDE_ADDITIONAL_TOOLTIP);
        }
        if (item instanceof SpawnEggItem || item instanceof HangingEntityItem || item instanceof ArmorStandItem || item instanceof MinecartItem || item instanceof BoatItem) {
            relevant.add(DataComponents.ENTITY_DATA);
        }
        if (item instanceof BlockItem) {
            Block block = ((BlockItem)item).getBlock();
            relevant.add(DataComponents.CAN_PLACE_ON);
            if (!block.defaultBlockState().getProperties().isEmpty()) {
                relevant.add(DataComponents.BLOCK_STATE);
            }
            if (block instanceof EntityBlock) {
                DataComponentManager.getHardcodedBlockEntityRelevant(relevant, block);
            }
            if (block instanceof DecoratedPotBlock) {
                relevant.add(DataComponents.POT_DECORATIONS);
            }
            if (block instanceof PlayerHeadBlock) {
                relevant.add(DataComponents.NOTE_BLOCK_SOUND);
                relevant.add(DataComponents.PROFILE);
            }
        } else {
            if (item == Items.DEBUG_STICK) {
                relevant.add(DataComponents.DEBUG_STICK_STATE);
            }
            if (item instanceof FireworkStarItem) {
                relevant.add(DataComponents.FIREWORK_EXPLOSION);
            }
            if (item instanceof FireworkRocketItem) {
                relevant.add(DataComponents.FIREWORKS);
            }
            if (item instanceof InstrumentItem) {
                relevant.add(DataComponents.INSTRUMENT);
            }
            if (item instanceof CrossbowItem) {
                relevant.add(DataComponents.CHARGED_PROJECTILES);
            }
            if (item instanceof ArrowItem) {
                relevant.add(DataComponents.INTANGIBLE_PROJECTILE);
            }
            if (item instanceof CompassItem) {
                relevant.add(DataComponents.LODESTONE_TRACKER);
            }
            if (item instanceof OminousBottleItem) {
                relevant.add(DataComponents.OMINOUS_BOTTLE_AMPLIFIER);
            }
            if (item instanceof KnowledgeBookItem) {
                relevant.add(DataComponents.RECIPES);
            }
            if (item instanceof EnchantedBookItem) {
                relevant.add(DataComponents.STORED_ENCHANTMENTS);
            }
            if (item instanceof WritableBookItem) {
                relevant.add(DataComponents.WRITABLE_BOOK_CONTENT);
            }
            if (item instanceof WrittenBookItem) {
                relevant.add(DataComponents.WRITTEN_BOOK_CONTENT);
            }
            if (item instanceof ArmorItem && ((ArmorItem)item).getType() != ArmorItem.Type.BODY) {
                relevant.add(DataComponents.TRIM);
            }
            if (item instanceof PotionItem || item instanceof TippedArrowItem) {
                relevant.add(DataComponents.POTION_CONTENTS);
            }
            if (item instanceof MapItem) {
                relevant.add(DataComponents.MAP_COLOR);
                relevant.add(DataComponents.MAP_DECORATIONS);
                relevant.add(DataComponents.MAP_ID);
            }
            if (Fields.isMethodOverridden(Fields.itemUseOnMethodData, item, Item.class)) {
                relevant.add(DataComponents.CAN_PLACE_ON);
            }
        }
        return relevant;
    }

    private static void getHardcodedBlockEntityRelevant(Set<DataComponentType<?>> relevant, Block block) {
        relevant.add(DataComponents.BLOCK_ENTITY_DATA);
        BlockEntity blockEntity = TypeLoader.blockEntityFromBlock(block);
        if (blockEntity instanceof Container) {
            relevant.add(DataComponents.CONTAINER);
            if (blockEntity instanceof RandomizableContainer) {
                relevant.add(DataComponents.CONTAINER_LOOT);
            }
            if (blockEntity instanceof BaseContainerBlockEntity) {
                relevant.add(DataComponents.LOCK);
            }
        }
    }
}

