/*
 * Decompiled with CFR 0.152.
 */
package com.ametrinstudios.ametrin.world.item.helper;

import java.util.EnumMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public final class ArmorMaterialBuilder {
    private final EnumMap<ArmorItem.Type, Integer> _defence = new EnumMap(ArmorItem.Type.class);
    private int _enchantmentValue = 0;
    private Holder<SoundEvent> _equipSound = SoundEvents.ARMOR_EQUIP_IRON;
    private Supplier<Ingredient> _repairIngredient = () -> Ingredient.EMPTY;
    private final List<ArmorMaterial.Layer> _layers;
    private float _toughness = 0.0f;
    private float _knockbackResistance = 0.0f;

    public ArmorMaterialBuilder(String name) {
        this._layers = List.of(new ArmorMaterial.Layer(ResourceLocation.withDefaultNamespace((String)name)));
    }

    public ArmorMaterialBuilder defence(Consumer<EnumMap<ArmorItem.Type, Integer>> defence) {
        defence.accept(this._defence);
        return this;
    }

    public ArmorMaterialBuilder enchantmentValue(int value) {
        this._enchantmentValue = value;
        return this;
    }

    public ArmorMaterialBuilder equipSound(Holder<SoundEvent> equipSound) {
        this._equipSound = equipSound;
        return this;
    }

    public ArmorMaterialBuilder repairIngredient(Supplier<Ingredient> repairIngredient) {
        this._repairIngredient = repairIngredient;
        return this;
    }

    public ArmorMaterialBuilder repairItem(Supplier<ItemLike> repairIngredient) {
        return this.repairIngredient(() -> Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)repairIngredient.get()}));
    }

    public ArmorMaterialBuilder toughness(float value) {
        this._toughness = value;
        return this;
    }

    public ArmorMaterialBuilder knockbackResistance(float value) {
        this._knockbackResistance = value;
        return this;
    }

    public ArmorMaterial build() {
        return new ArmorMaterial(this._defence, this._enchantmentValue, this._equipSound, this._repairIngredient, this._layers, this._toughness, this._knockbackResistance);
    }
}

