/*
 * Decompiled with CFR 0.152.
 */
package com.ametrinstudios.ametrin.world.item;

import com.ametrinstudios.ametrin.world.dimension.portal.CustomPortalShape;
import com.ametrinstudios.ametrin.world.dimension.portal.PortalData;
import java.util.Optional;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;

public class PortalCatalystItem
extends Item {
    protected final PortalData portalData;

    public PortalCatalystItem(PortalData portalData, Item.Properties properties) {
        super(properties);
        this.portalData = portalData;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        Level level = context.getLevel();
        if (!this.portalData.isValidDimension(level) || player == null) {
            return InteractionResult.FAIL;
        }
        Optional<CustomPortalShape> portalShape = this.portalData.findPortalShape((LevelAccessor)context.getLevel(), context.getClickedPos().above(), Direction.Axis.X);
        if (portalShape.isEmpty()) {
            return InteractionResult.FAIL;
        }
        portalShape.get().createPortalBlocks();
        level.playSound(context.getPlayer(), context.getClickedPos(), SoundEvents.PORTAL_TRIGGER, SoundSource.BLOCKS, 0.9f, 1.0f);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ItemStack itemStack = context.getItemInHand();
            CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, context.getClickedPos(), itemStack);
            itemStack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }
}

