/*
 * Decompiled with CFR 0.152.
 */
package com.ametrinstudios.ametrin.world.item;

import com.ametrinstudios.ametrin.world.block.CustomHeadBlock;
import com.ametrinstudios.ametrin.world.block.CustomWallHeadBlock;
import java.util.function.Supplier;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomHeadBlockItem
extends BlockItem {
    protected final Supplier<CustomHeadBlock> block;
    protected final Supplier<CustomWallHeadBlock> wallBlock;

    public CustomHeadBlockItem(Supplier<CustomHeadBlock> block, Supplier<CustomWallHeadBlock> wallBlock, Item.Properties pProperties) {
        super((Block)block.get(), pProperties);
        this.block = block;
        this.wallBlock = wallBlock;
    }

    @Nullable
    protected BlockState getPlacementState(@NotNull BlockPlaceContext context) {
        if (context.getClickedFace() == Direction.DOWN) {
            return null;
        }
        BlockState blockState = context.getClickedFace() == Direction.UP ? this.getBlock().getStateForPlacement(context) : this.getWallBlock().getStateForPlacement(context);
        return blockState != null && this.canPlace(context, blockState) ? blockState : null;
    }

    @NotNull
    public Block getBlock() {
        return this.block.get();
    }

    @NotNull
    public Block getWallBlock() {
        return this.wallBlock.get();
    }

    public boolean canFitInsideContainerItems() {
        return true;
    }
}

