/*
 * Decompiled with CFR 0.152.
 */
package com.ametrinstudios.ametrin.world.gen.util;

import com.mojang.datafixers.util.Pair;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;

public final class TerrainAnalyzer {
    public static Pair<Float, Boolean> isFlatEnough(BlockPos pos, Vec3i size, int padding, int threshold, Context context) {
        if (context.generator() instanceof FlatLevelSource) {
            return Pair.of((Object)Float.valueOf(context.generator().getBaseHeight(pos.getX(), pos.getZ(), Heightmap.Types.OCEAN_FLOOR_WG, context.heightAccessor(), context.randomState())), (Object)true);
        }
        int x1 = pos.getX() + padding;
        int z1 = pos.getZ() + padding;
        int x2 = pos.getX() + size.getX() - padding;
        int z2 = pos.getZ() + size.getZ() - padding;
        int height1 = context.generator().getBaseHeight(x1, z1, Heightmap.Types.OCEAN_FLOOR_WG, context.heightAccessor(), context.randomState());
        int height2 = context.generator().getBaseHeight(x2, z1, Heightmap.Types.OCEAN_FLOOR_WG, context.heightAccessor(), context.randomState());
        int height3 = context.generator().getBaseHeight(x2, z2, Heightmap.Types.OCEAN_FLOOR_WG, context.heightAccessor(), context.randomState());
        int height4 = context.generator().getBaseHeight(x1, z2, Heightmap.Types.OCEAN_FLOOR_WG, context.heightAccessor(), context.randomState());
        float averageHeight = (float)(height1 + height2 + height3 + height4) / 4.0f;
        float averageHeightDifference = (Math.abs(averageHeight - (float)height1) + Math.abs(averageHeight - (float)height2) + Math.abs(averageHeight - (float)height3) + Math.abs(averageHeight - (float)height4)) / 4.0f;
        return Pair.of((Object)Float.valueOf(averageHeight), (Object)(averageHeightDifference < (float)threshold ? 1 : 0));
    }

    public static boolean isUnderwater(BlockPos pos, int depth, Context context) {
        return TerrainAnalyzer.getBlockAt(pos.above(depth), context).is(Blocks.WATER);
    }

    public static boolean isGroundLevelAbove(BlockPos pos, int height, Context context) {
        return TerrainAnalyzer.isGroundLevelAbove(pos.getX(), pos.getZ(), height, context);
    }

    public static boolean isGroundLevelAbove(int x, int z, int height, Context context) {
        return context.generator().getBaseHeight(x, z, Heightmap.Types.OCEAN_FLOOR_WG, context.heightAccessor(), context.randomState()) > height;
    }

    public static boolean isGroundLevelBelow(BlockPos pos, int height, Context context) {
        return TerrainAnalyzer.isGroundLevelBelow(pos.getX(), pos.getZ(), height, context);
    }

    public static boolean isGroundLevelBelow(int x, int z, int height, Context context) {
        return context.generator().getBaseHeight(x, z, Heightmap.Types.OCEAN_FLOOR_WG, context.heightAccessor(), context.randomState()) < height;
    }

    public static boolean areNearbyBiomesValid(BlockPos pos, int radius, Predicate<Holder<Biome>> biomePredicate, BiomeSource biomeSource, ChunkGenerator generator, RandomState randomState) {
        for (Holder biome : biomeSource.getBiomesWithin(pos.getX(), generator.getSeaLevel(), pos.getZ(), radius, randomState.sampler())) {
            if (biomePredicate.test((Holder<Biome>)biome)) continue;
            return false;
        }
        return true;
    }

    public static BlockState getBlockAt(BlockPos pos, Context context) {
        return TerrainAnalyzer.getBlockAt(pos.getX(), pos.getY(), pos.getZ(), context);
    }

    public static BlockState getBlockAt(int x, int y, int z, Context context) {
        return context.generator().getBaseColumn(x, z, context.heightAccessor(), context.randomState()).getBlock(y);
    }

    public static Context context(ChunkGenerator generator, LevelHeightAccessor heightAccessor, RandomState randomState) {
        return new Context(generator, heightAccessor, randomState);
    }

    public static Context context(Structure.GenerationContext generationContext) {
        return TerrainAnalyzer.context(generationContext.chunkGenerator(), generationContext.heightAccessor(), generationContext.randomState());
    }

    public record Context(ChunkGenerator generator, LevelHeightAccessor heightAccessor, RandomState randomState) {
    }
}

