/*
 * Decompiled with CFR 0.152.
 */
package com.ametrinstudios.ametrin.world.gen.util;

import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;

public class StructurePieces {
    private final SimpleWeightedRandomList<Piece> pieces;

    protected StructurePieces(Builder builder) {
        this(builder.buildList());
    }

    protected StructurePieces(SimpleWeightedRandomList<Piece> pieces) {
        if (pieces.isEmpty()) {
            throw new IllegalArgumentException("Cannot create an empty StructurePieces instance");
        }
        this.pieces = pieces;
    }

    public Piece getRandomPiece(RandomSource random) {
        return (Piece)this.pieces.getRandomValue(random).get();
    }

    public static class Builder {
        private final SimpleWeightedRandomList.Builder<Piece> pieces;
        private BlockPos offset = BlockPos.ZERO;
        private int weight = 1;

        public Builder() {
            this.pieces = SimpleWeightedRandomList.builder();
        }

        public Builder weight(int weight) {
            this.weight = weight;
            return this;
        }

        public Builder offset(BlockPos offset) {
            this.offset = offset;
            return this;
        }

        public Builder offset(int x, int y, int z) {
            return this.offset(new BlockPos(x, y, z));
        }

        public Builder offsetY(int y) {
            return this.offset(0, y, 0);
        }

        public Builder add(ResourceLocation resource) {
            this.pieces.add((Object)new Piece(resource, this.offset), this.weight);
            return this;
        }

        private SimpleWeightedRandomList<Piece> buildList() {
            return this.pieces.build();
        }

        public StructurePieces build() {
            return new StructurePieces(this);
        }
    }

    public static class Piece {
        public final ResourceLocation Resource;
        public final BlockPos Offset;

        public Piece(ResourceLocation resource, BlockPos offset) {
            this.Resource = resource;
            this.Offset = offset;
        }
    }
}

