/*
 * Decompiled with CFR 0.152.
 */
package com.ametrinstudios.ametrin.world.gen.structure.processor;

import com.ametrinstudios.ametrin.world.gen.structure.processor.AmProcessorTypes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Random;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeepStateRandomBlockSwapProcessor
extends StructureProcessor {
    public static final MapCodec<KeepStateRandomBlockSwapProcessor> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("condition").forGetter(processor -> processor.condition), (App)Codec.FLOAT.fieldOf("chance").forGetter(processor -> Float.valueOf(processor.chance)), (App)BuiltInRegistries.BLOCK.byNameCodec().fieldOf("change_to").forGetter(processor -> processor.changeTo)).apply((Applicative)instance, KeepStateRandomBlockSwapProcessor::new));
    protected final Block condition;
    protected final float chance;
    protected final Block changeTo;

    public KeepStateRandomBlockSwapProcessor(Block condition, float chance, Block changeTo) {
        this.condition = condition;
        this.chance = chance;
        this.changeTo = changeTo;
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public StructureTemplate.StructureBlockInfo process(LevelReader level, BlockPos pos, BlockPos pos2, StructureTemplate.StructureBlockInfo existing, StructureTemplate.StructureBlockInfo placed, StructurePlaceSettings settings, @Nullable StructureTemplate template) {
        block2: {
            block3: {
                if (!placed.state().is(this.condition)) break block2;
                if (this.chance == 1.0f) break block3;
                Random random = new Random(Mth.getSeed((Vec3i)placed.pos()));
                if (!(random.nextFloat() < this.chance)) break block2;
            }
            return new StructureTemplate.StructureBlockInfo(placed.pos(), this.changeTo.withPropertiesOf(placed.state()), placed.nbt());
        }
        return placed;
    }

    @NotNull
    protected StructureProcessorType<?> getType() {
        return AmProcessorTypes.KEEP_STATE_RANDOM_BLOCK_SWAP;
    }
}

