/*
 * Decompiled with CFR 0.152.
 */
package com.ametrinstudios.ametrin.world.gen.feature.tree.helper;

import com.ametrinstudios.ametrin.world.gen.feature.tree.helper.TreeHelper;
import com.ametrinstudios.ametrin.world.gen.feature.tree.helper.TreePlaceContext;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.state.BlockState;

public final class TreeHelper2x2 {
    public static final double CIRCULAR_LEAVES_ROUNDING_MULTIPLIER = 1.76;

    public static BlockPos placeTrunk(BlockState log, int height, TreePlaceContext context) {
        for (int y = 0; y < height; ++y) {
            TreeHelper.setBlockChecked(log, context.pos().offset(0, y, 0), context.level(), context.changedLogs());
            TreeHelper.setBlockChecked(log, context.pos().offset(0, y, 1), context.level(), context.changedLogs());
            TreeHelper.setBlockChecked(log, context.pos().offset(1, y, 0), context.level(), context.changedLogs());
            TreeHelper.setBlockChecked(log, context.pos().offset(1, y, 1), context.level(), context.changedLogs());
        }
        return context.pos().above(height);
    }

    protected void circularLeaves(BlockState leaf, int radius, TreePlaceContext context) {
        for (int x = -radius; x <= radius + 1; ++x) {
            for (int z = -radius; z <= radius + 1; ++z) {
                int dX = Math.abs(x);
                int dZ = Math.abs(z);
                if (x < 0) {
                    ++dX;
                }
                if (z < 0) {
                    ++dZ;
                }
                if ((double)(dX + dZ) > (double)radius * 1.76) continue;
                TreeHelper.setBlockChecked(leaf, context.pos().offset(x, 0, z), context.level(), context.changedLeaves());
            }
        }
    }

    protected void circularSparseLeaves(BlockState leaf, int radius, TreePlaceContext context) {
        for (int x = -radius; x <= radius + 1; ++x) {
            for (int z = -radius; z <= radius + 1; ++z) {
                if (context.random().nextBoolean()) continue;
                int dX = Math.abs(x);
                int dZ = Math.abs(z);
                if (x < 0) {
                    ++dX;
                }
                if (z < 0) {
                    ++dZ;
                }
                if (!((double)(dX + dZ) <= (double)radius * 1.76)) continue;
                TreeHelper.setBlockChecked(leaf, context.pos().offset(x, 0, z), context.level(), context.changedLeaves());
            }
        }
    }

    protected void circularSparseLeaves(BlockState leaf, int radius, double decayChance, TreePlaceContext context) {
        for (int x = -radius; x <= radius + 1; ++x) {
            for (int z = -radius; z <= radius + 1; ++z) {
                if (context.random().nextDouble() <= decayChance) continue;
                int dX = Math.abs(x);
                int dZ = Math.abs(z);
                if (x < 0) {
                    ++dX;
                }
                if (z < 0) {
                    ++dZ;
                }
                if (!((double)(dX + dZ) <= (double)radius * 1.76)) continue;
                TreeHelper.setBlockChecked(leaf, context.pos().offset(x, 0, z), context.level(), context.changedLeaves());
            }
        }
    }
}

